/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Deque;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgumentParser;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Command;

public class ConnectionAndSslParameters<A extends IgniteDataTransferObject> {
    private String user;
    private String pwd;
    private char[] sslKeyStorePassword;
    private char[] sslTrustStorePassword;
    private final Deque<Command<?, ?>> cmdPath;
    private final A arg;
    private final CLIArgumentParser parser;

    public ConnectionAndSslParameters(Deque<Command<?, ?>> cmdPath, A arg, CLIArgumentParser parser) {
        this.cmdPath = cmdPath;
        this.arg = arg;
        this.parser = parser;
        this.user = (String)parser.get("--user");
        this.pwd = (String)parser.get("--password");
        this.sslKeyStorePassword = (char[])parser.get("--keystore-password");
        this.sslTrustStorePassword = (char[])parser.get("--truststore-password");
    }

    public Command<A, ?> command() {
        return this.cmdPath.peek();
    }

    public Deque<Command<?, ?>> cmdPath() {
        return this.cmdPath;
    }

    public A commandArg() {
        return this.arg;
    }

    public String host() {
        return (String)this.parser.get("--host");
    }

    public int port() {
        return (Integer)this.parser.get("--port");
    }

    public String userName() {
        return this.user;
    }

    public void userName(String user) {
        this.user = user;
    }

    public String password() {
        return this.pwd;
    }

    public void password(String pwd) {
        this.pwd = pwd;
    }

    public long pingTimeout() {
        return (Long)this.parser.get("--ping-timeout");
    }

    public long pingInterval() {
        return (Long)this.parser.get("--ping-interval");
    }

    public boolean autoConfirmation() {
        return (Boolean)this.parser.get("--yes");
    }

    public String[] sslProtocol() {
        return (String[])this.parser.get("--ssl-protocol");
    }

    public String[] getSslCipherSuites() {
        return (String[])this.parser.get("--ssl-cipher-suites");
    }

    public String sslKeyAlgorithm() {
        return (String)this.parser.get("--ssl-key-algorithm");
    }

    public String sslKeyStorePath() {
        return (String)this.parser.get("--keystore");
    }

    public String sslKeyStoreType() {
        return (String)this.parser.get("--keystore-type");
    }

    public char[] sslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public void sslKeyStorePassword(char[] sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
    }

    public String sslTrustStorePath() {
        return (String)this.parser.get("--truststore");
    }

    public String sslTrustStoreType() {
        return (String)this.parser.get("--truststore-type");
    }

    public char[] sslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public void sslTrustStorePassword(char[] sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    public String sslFactoryConfigPath() {
        return (String)this.parser.get("--ssl-factory");
    }

    public boolean verbose() {
        return (Boolean)this.parser.get("--verbose");
    }
}

