/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlanningContext;

public class PlanUtils {
    public static String deriveSchemaName(SqlIdentifier id, PlanningContext ctx) {
        String schemaName;
        if (id.isSimple()) {
            schemaName = ctx.schemaName();
        } else {
            SqlIdentifier schemaId = id.skipLast(1);
            if (!schemaId.isSimple()) {
                throw new IgniteSQLException("Unexpected value of schemaName [expected a simple identifier, but was " + schemaId + "; querySql=\"" + ctx.query() + "\"]", 1001);
            }
            schemaName = schemaId.getSimple();
        }
        PlanUtils.ensureSchemaExists(ctx.unwrap(BaseQueryContext.class), schemaName);
        return schemaName;
    }

    public static String deriveObjectName(SqlIdentifier id, PlanningContext ctx, String objDesc) {
        if (id.isSimple()) {
            return id.getSimple();
        }
        SqlIdentifier objId = id.getComponent(id.skipLast((int)1).names.size());
        if (!objId.isSimple()) {
            throw new IgniteSQLException("Unexpected value of " + objDesc + " [expected a simple identifier, but was " + objId + "; querySql=\"" + ctx.query() + "\"]", 1001);
        }
        return objId.getSimple();
    }

    private static void ensureSchemaExists(BaseQueryContext ctx, String schemaName) {
        if (ctx.catalogReader().getRootSchema().getSubSchema(schemaName, true) == null) {
            throw new IgniteSQLException("Schema with name " + schemaName + " not found", 3015);
        }
    }
}

