/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule.logical;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.hint.HintDefinition;
import org.apache.ignite.internal.processors.query.calcite.hint.HintUtils;
import org.apache.ignite.internal.processors.query.calcite.rel.AbstractIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.ImmutableExposeIndexRule;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.immutables.value.Value;

@Value.Enclosing
public class ExposeIndexRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    public ExposeIndexRule(Config config) {
        super((RelRule.Config)config);
    }

    private static boolean preMatch(IgniteLogicalTableScan scan) {
        return !((IgniteTable)scan.getTable().unwrap(IgniteTable.class)).indexes().isEmpty();
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)call.rel(0);
        RelOptCluster cluster = scan.getCluster();
        RelOptTable optTable = scan.getTable();
        IgniteTable igniteTable = (IgniteTable)optTable.unwrap(IgniteTable.class);
        List<RexNode> proj = scan.projects();
        RexNode condition = scan.condition();
        ImmutableBitSet requiredCols = scan.requiredColumns();
        if (igniteTable.isIndexRebuildInProgress()) {
            return;
        }
        List indexes = igniteTable.indexes().values().stream().map(idx -> idx.toRel(cluster, optTable, proj, condition, requiredCols)).collect(Collectors.toList());
        assert (!indexes.isEmpty());
        IgniteBiTuple<List<IgniteLogicalIndexScan>, Boolean> hintedIndexes = this.processHints(scan, indexes);
        if ((indexes = (List)hintedIndexes.get1()).isEmpty()) {
            return;
        }
        if (((Boolean)hintedIndexes.get2()).booleanValue()) {
            cluster.getPlanner().prune((RelNode)scan);
        }
        HashMap<RelNode, IgniteLogicalTableScan> equivMap = new HashMap<RelNode, IgniteLogicalTableScan>(indexes.size());
        for (int i = 1; i < indexes.size(); ++i) {
            equivMap.put((RelNode)indexes.get(i), scan);
        }
        call.transformTo((RelNode)F.first((List)indexes), equivMap);
    }

    private IgniteBiTuple<List<IgniteLogicalIndexScan>, Boolean> processHints(TableScan scan, List<IgniteLogicalIndexScan> indexes) {
        assert (!F.isEmpty(indexes));
        Set tblIdxNames = indexes.stream().map(AbstractIndexScan::indexName).collect(Collectors.toSet());
        HashSet<String> idxToSkip = new HashSet<String>();
        HashSet<String> idxToUse = new HashSet<String>();
        for (RelHint hint : HintUtils.hints((RelNode)scan, HintDefinition.NO_INDEX, HintDefinition.FORCE_INDEX)) {
            boolean skip = !hint.hintName.equals(HintDefinition.FORCE_INDEX.name());
            Collection<Object> hintIdxNames = hint.listOptions.isEmpty() ? tblIdxNames : hint.listOptions;
            for (String string : hintIdxNames) {
                if (!tblIdxNames.contains(string)) continue;
                if (idxToSkip.contains(string) || idxToUse.contains(string)) {
                    HintUtils.skippedHint((RelNode)scan, hint, "Index '" + string + "' of table '" + (String)Util.last((List)scan.getTable().getQualifiedName()) + "' has already been excluded or forced to use by other options or other hints before.");
                    continue;
                }
                if (skip) {
                    idxToSkip.add(string);
                    continue;
                }
                idxToUse.add(string);
            }
        }
        return new IgniteBiTuple(indexes.stream().filter(idx -> !idxToSkip.contains(idx.indexName()) && (idxToUse.isEmpty() || idxToUse.contains(idx.indexName()))).collect(Collectors.toList()), (Object)(!idxToUse.isEmpty() ? 1 : 0));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableExposeIndexRule.Config.of().withOperandSupplier(b -> b.operand(IgniteLogicalTableScan.class).predicate(x$0 -> ExposeIndexRule.preMatch(x$0)).anyInputs());

        default public ExposeIndexRule toRule() {
            return new ExposeIndexRule(this);
        }
    }
}

