/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationMappingException;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMapping;
import org.apache.ignite.internal.processors.query.calcite.metadata.IgniteMetadata;
import org.apache.ignite.internal.processors.query.calcite.metadata.NodeMappingException;
import org.apache.ignite.internal.processors.query.calcite.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteFilter;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexBound;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexCount;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTrimExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteValues;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteMethod;

public class IgniteMdFragmentMapping
implements MetadataHandler<IgniteMetadata.FragmentMappingMetadata> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)IgniteMethod.FRAGMENT_MAPPING.method(), (MetadataHandler)new IgniteMdFragmentMapping());

    public MetadataDef<IgniteMetadata.FragmentMappingMetadata> getDef() {
        return IgniteMetadata.FragmentMappingMetadata.DEF;
    }

    public FragmentMapping fragmentMapping(RelNode rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        throw new AssertionError();
    }

    public FragmentMapping fragmentMapping(RelSubset rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        throw new AssertionError();
    }

    public FragmentMapping fragmentMapping(SingleRel rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return IgniteMdFragmentMapping._fragmentMapping(rel.getInput(), mq, ctx);
    }

    public FragmentMapping fragmentMapping(BiRel rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        FragmentMapping fLeft = IgniteMdFragmentMapping._fragmentMapping(left, mq, ctx);
        FragmentMapping fRight = IgniteMdFragmentMapping._fragmentMapping(right, mq, ctx);
        try {
            return fLeft.colocate(fRight);
        }
        catch (ColocationMappingException e) {
            IgniteExchange lExch = new IgniteExchange(rel.getCluster(), left.getTraitSet(), left, TraitUtils.distribution(left));
            IgniteExchange rExch = new IgniteExchange(rel.getCluster(), right.getTraitSet(), right, TraitUtils.distribution(right));
            RelNode lVar = rel.copy(rel.getTraitSet(), (List)ImmutableList.of((Object)lExch, (Object)right));
            RelNode rVar = rel.copy(rel.getTraitSet(), (List)ImmutableList.of((Object)left, (Object)rExch));
            RelOptCost lVarCost = mq.getCumulativeCost(lVar);
            RelOptCost rVarCost = mq.getCumulativeCost(rVar);
            if (lVarCost.isLt(rVarCost)) {
                throw new NodeMappingException("Failed to calculate physical distribution", left, e);
            }
            throw new NodeMappingException("Failed to calculate physical distribution", right, e);
        }
    }

    public FragmentMapping fragmentMapping(SetOp rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        FragmentMapping res = null;
        if (TraitUtils.distribution((RelNode)rel) == IgniteDistributions.random()) {
            for (RelNode input : rel.getInputs()) {
                res = res == null ? IgniteMdFragmentMapping._fragmentMapping(input, mq, ctx) : res.combine(IgniteMdFragmentMapping._fragmentMapping(input, mq, ctx));
            }
        } else {
            for (RelNode input : rel.getInputs()) {
                try {
                    res = res == null ? IgniteMdFragmentMapping._fragmentMapping(input, mq, ctx) : res.colocate(IgniteMdFragmentMapping._fragmentMapping(input, mq, ctx));
                }
                catch (ColocationMappingException e) {
                    throw new NodeMappingException("Failed to calculate physical distribution", input, e);
                }
            }
        }
        return res;
    }

    public FragmentMapping fragmentMapping(IgniteFilter rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return IgniteMdFragmentMapping._fragmentMapping(rel.getInput(), mq, ctx);
    }

    public FragmentMapping fragmentMapping(IgniteTrimExchange rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        try {
            return FragmentMapping.create(rel.sourceId()).colocate(IgniteMdFragmentMapping._fragmentMapping(rel.getInput(), mq, ctx));
        }
        catch (ColocationMappingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public FragmentMapping fragmentMapping(IgniteReceiver rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return FragmentMapping.create(rel.exchangeId());
    }

    public FragmentMapping fragmentMapping(IgniteIndexScan rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return FragmentMapping.create(rel.sourceId(), ((IgniteTable)rel.getTable().unwrap(IgniteTable.class)).colocationGroup(ctx));
    }

    public FragmentMapping fragmentMapping(IgniteIndexCount rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return FragmentMapping.create(rel.sourceId(), ((IgniteTable)rel.getTable().unwrap(IgniteTable.class)).colocationGroup(ctx));
    }

    public FragmentMapping fragmentMapping(IgniteIndexBound rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return FragmentMapping.create(rel.sourceId(), ((IgniteTable)rel.getTable().unwrap(IgniteTable.class)).colocationGroup(ctx));
    }

    public FragmentMapping fragmentMapping(IgniteTableScan rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return FragmentMapping.create(rel.sourceId(), ((IgniteTable)rel.getTable().unwrap(IgniteTable.class)).colocationGroup(ctx));
    }

    public FragmentMapping fragmentMapping(IgniteValues rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return FragmentMapping.create();
    }

    public FragmentMapping fragmentMapping(IgniteTableFunctionScan rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        return FragmentMapping.create();
    }

    public static FragmentMapping _fragmentMapping(RelNode rel, RelMetadataQuery mq, MappingQueryContext ctx) {
        assert (mq instanceof RelMetadataQueryEx);
        return ((RelMetadataQueryEx)mq).fragmentMapping(rel, ctx);
    }
}

