/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.HashSet;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReduceIndexAdapter;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceTable;
import org.apache.ignite.internal.processors.query.h2.twostep.SortedReducer;
import org.h2.engine.Session;
import org.h2.index.IndexType;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class SortedReduceIndexAdapter
extends AbstractReduceIndexAdapter {
    private static final IndexType TYPE = IndexType.createNonUnique((boolean)false);
    private final SortedReducer delegate;

    public SortedReduceIndexAdapter(GridKernalContext ctx, ReduceTable tbl, String name, IndexColumn[] cols) {
        super(ctx, (Table)tbl, name, TYPE, cols);
        this.delegate = new SortedReducer(ctx, this::compareRows);
    }

    @Override
    protected SortedReducer reducer() {
        return this.delegate;
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return this.getCostRangeIndex(masks, this.getRowCountApproximation(), filters, filter, sortOrder, false, allColumnsSet);
    }

    public int compareRows(SearchRow rowData, SearchRow compare) {
        if (rowData == compare) {
            return 0;
        }
        int len = this.indexColumns.length;
        for (int i = 0; i < len; ++i) {
            int idx = this.columnIds[i];
            int sortType = this.indexColumns[i].sortType;
            Value v1 = rowData.getValue(idx);
            Value v2 = compare.getValue(idx);
            if (v1 == null || v2 == null) {
                return 0;
            }
            if (v1 == v2) continue;
            if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE) {
                if ((sortType & 2) != 0) {
                    return v1 == ValueNull.INSTANCE ? -1 : 1;
                }
                if ((sortType & 4) != 0) {
                    return v1 == ValueNull.INSTANCE ? 1 : -1;
                }
            }
            int comp = this.table.compareTypeSafe(v1, v2);
            if ((sortType & 1) != 0) {
                comp = -comp;
            }
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }
}

