/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel.agg;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

interface IgniteSortAggregateBase
extends TraitsAwareIgniteRel {
    public ImmutableBitSet getGroupSet();

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation collation;
        RelCollation required = TraitUtils.collation(nodeTraits);
        ImmutableBitSet requiredKeys = ImmutableBitSet.of((ImmutableIntList)required.getKeys());
        if (this.getGroupSet().contains(requiredKeys)) {
            ArrayList newCollationFields = new ArrayList(this.getGroupSet().cardinality());
            newCollationFields.addAll(required.getFieldCollations());
            ImmutableBitSet keysLeft = this.getGroupSet().except(requiredKeys);
            keysLeft.forEach(fieldIdx -> newCollationFields.add(TraitUtils.createFieldCollation(fieldIdx)));
            collation = RelCollations.of(newCollationFields);
        } else {
            collation = TraitUtils.createCollation(this.getGroupSet().asList());
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)collation), (Object)ImmutableList.of((Object)inputTraits.get(0).replace((RelTrait)collation)));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation inputCollation = TraitUtils.collation(inputTraits.get(0));
        List newCollationColls = Commons.maxPrefix(inputCollation.getKeys(), this.getGroupSet().asSet());
        if (newCollationColls.size() < this.getGroupSet().cardinality()) {
            return ImmutableList.of();
        }
        List suitableCollations = inputCollation.getFieldCollations().stream().filter(k -> newCollationColls.contains(k.getFieldIndex())).collect(Collectors.toList());
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.of(suitableCollations)), inputTraits));
    }
}

