/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.metadata.IgniteMetadata;
import org.apache.ignite.internal.processors.query.calcite.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteSqlToRelConvertor;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteSqlValidator;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlannerPhase;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlanningContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.ValidationResult;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IgnitePlanner
implements Planner,
RelOptTable.ViewExpander {
    private final SqlOperatorTable operatorTbl;
    private final ImmutableList<Program> programs;
    private final FrameworkConfig frameworkCfg;
    private final PlanningContext ctx;
    private final ImmutableList<RelTraitDef> traitDefs;
    private final SqlParser.Config parserCfg;
    private final SqlToRelConverter.Config sqlToRelConverterCfg;
    private final SqlValidator.Config validatorCfg;
    private final SqlRexConvertletTable convertletTbl;
    private final RexExecutor rexExecutor;
    private final IgniteTypeFactory typeFactory;
    private final CalciteCatalogReader catalogReader;
    private RelOptPlanner planner;
    private SqlValidator validator;
    private RelOptCluster cluster;
    @Nullable
    private SqlNode validatedSqlNode;

    IgnitePlanner(PlanningContext ctx) {
        this.ctx = ctx;
        this.typeFactory = ctx.typeFactory();
        this.catalogReader = ctx.catalogReader();
        this.operatorTbl = ctx.opTable();
        this.frameworkCfg = ctx.config();
        this.programs = this.frameworkCfg.getPrograms();
        this.parserCfg = this.frameworkCfg.getParserConfig();
        this.sqlToRelConverterCfg = this.frameworkCfg.getSqlToRelConverterConfig();
        this.validatorCfg = this.frameworkCfg.getSqlValidatorConfig();
        this.convertletTbl = this.frameworkCfg.getConvertletTable();
        this.rexExecutor = this.frameworkCfg.getExecutor();
        this.traitDefs = this.frameworkCfg.getTraitDefs();
    }

    public RelTraitSet getEmptyTraitSet() {
        return this.planner().emptyTraitSet();
    }

    public void close() {
        this.reset();
    }

    public void reset() {
        this.planner = null;
        this.validator = null;
        this.cluster = null;
    }

    public SqlNode parse(Reader reader) throws SqlParseException {
        SqlNodeList sqlNodes = Commons.parse(reader, this.parserCfg);
        return sqlNodes.size() == 1 ? sqlNodes.get(0) : sqlNodes;
    }

    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        try {
            this.validatedSqlNode = this.validator().validate(sqlNode);
            return this.validatedSqlNode;
        }
        catch (RuntimeException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) {
        SqlNode validatedNode = this.validator().validate(sqlNode);
        RelDataType type = this.validator().getValidatedNodeType(validatedNode);
        return Pair.of((Object)validatedNode, (Object)type);
    }

    public RelDataType getParameterRowType() {
        return this.validator.getParameterRowType(this.validatedSqlNode);
    }

    public RelDataType convert(SqlDataTypeSpec typeSpec) {
        return typeSpec.deriveType(this.validator());
    }

    public ValidationResult validateAndGetTypeMetadata(SqlNode sqlNode) {
        ArrayList<String> derived;
        List origins;
        RelDataType type;
        SqlNode validatedNode;
        block14: {
            SqlNodeList selectItems = null;
            ArrayList<SqlNode> selectItemsNoStar = null;
            SqlNode sqlNode0 = sqlNode instanceof SqlOrderBy ? ((SqlOrderBy)sqlNode).query : sqlNode;
            boolean hasStar = false;
            if (sqlNode0 instanceof SqlSelect) {
                selectItems = SqlNonNullableAccessors.getSelectList((SqlSelect)((SqlSelect)sqlNode0));
                selectItemsNoStar = new ArrayList<SqlNode>(selectItems.size());
                for (SqlNode node : selectItems) {
                    if (node instanceof SqlIdentifier) {
                        if (!((SqlIdentifier)node).isStar()) continue;
                        hasStar = true;
                        continue;
                    }
                    selectItemsNoStar.add(node);
                }
            }
            validatedNode = this.validator().validate(sqlNode);
            type = this.validator().getValidatedNodeType(validatedNode);
            origins = this.validator().getFieldOrigins(validatedNode);
            derived = null;
            if (!(validatedNode instanceof SqlSelect) || F.isEmpty((Collection)selectItems) || F.isEmpty(selectItemsNoStar)) break block14;
            derived = new ArrayList<String>(selectItems.size());
            if (hasStar) {
                SqlNodeList expandedItems = ((SqlSelect)validatedNode).getSelectList();
                int cnt = 0;
                for (SqlNode node : expandedItems) {
                    if (node instanceof SqlIdentifier) {
                        derived.add(null);
                        continue;
                    }
                    if (node instanceof SqlBasicCall) {
                        if (cnt < selectItemsNoStar.size()) {
                            SqlNode noStarItem = (SqlNode)selectItemsNoStar.get(cnt);
                            if (IgnitePlanner.isAsCall(noStarItem) && IgnitePlanner.isAsCall(node)) {
                                SqlBasicCall origItem = (SqlBasicCall)noStarItem;
                                SqlBasicCall expandedItem = (SqlBasicCall)node;
                                if (Objects.equals(origItem.getParserPosition(), expandedItem.getParserPosition())) {
                                    derived.add(((SqlIdentifier)origItem.operand(1)).getSimple());
                                    ++cnt;
                                    continue;
                                }
                            } else {
                                derived.add(this.validator().deriveAlias(noStarItem, cnt++));
                                continue;
                            }
                        }
                        derived.add(null);
                        continue;
                    }
                    if (cnt < selectItemsNoStar.size()) {
                        derived.add(this.validator().deriveAlias((SqlNode)selectItemsNoStar.get(cnt), cnt++));
                        continue;
                    }
                    derived.add(null);
                }
            } else {
                int cnt = 0;
                for (SqlNode node : selectItems) {
                    derived.add(this.validator().deriveAlias(node, cnt++));
                }
            }
        }
        return new ValidationResult(validatedNode, type, origins, derived);
    }

    private static boolean isAsCall(SqlNode node) {
        return node instanceof SqlBasicCall && node.getKind() == SqlKind.AS && ((SqlBasicCall)node).operandCount() == 2 && ((SqlBasicCall)node).operand(0) instanceof SqlIdentifier && ((SqlBasicCall)node).operand(1) instanceof SqlIdentifier;
    }

    public RelNode convert(SqlNode sql) {
        throw new UnsupportedOperationException();
    }

    public RelRoot rel(SqlNode sql) {
        SqlToRelConverter sqlToRelConverter = this.sqlToRelConverter(this.validator(), this.catalogReader, this.sqlToRelConverterCfg);
        return sqlToRelConverter.convertQuery(sql, false, true);
    }

    public RelRoot expandView(RelDataType rowType, String qryStr, List<String> schemaPath, List<String> viewPath) {
        SqlNode sqlNode;
        SqlParser parser = SqlParser.create((String)qryStr, (SqlParser.Config)this.parserCfg);
        try {
            sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new IgniteSQLException("parse failed", 1001, (Throwable)e);
        }
        CalciteCatalogReader catalogReader = this.catalogReader.withSchemaPath(schemaPath);
        IgniteSqlValidator validator = new IgniteSqlValidator(this.operatorTbl, catalogReader, this.typeFactory, this.validatorCfg, this.ctx.parameters());
        SqlToRelConverter sqlToRelConverter = this.sqlToRelConverter((SqlValidator)validator, catalogReader, this.sqlToRelConverterCfg);
        RelRoot root = sqlToRelConverter.convertQuery(sqlNode, true, false);
        root = root.withRel(sqlToRelConverter.decorrelate(sqlNode, root.rel));
        return root;
    }

    public RelNode transform(int programIdx, RelTraitSet targetTraits, RelNode rel) {
        return ((Program)this.programs.get(programIdx)).run(this.planner(), rel, targetTraits.simplify(), this.materializations(), this.latices());
    }

    public <T extends RelNode> T transform(PlannerPhase phase, RelTraitSet targetTraits, RelNode rel) {
        return (T)phase.getProgram(this.ctx).run(this.planner(), rel, targetTraits.simplify(), this.materializations(), this.latices());
    }

    public IgniteTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    private RelOptPlanner planner() {
        if (this.planner == null) {
            VolcanoPlannerExt planner = new VolcanoPlannerExt(this.frameworkCfg.getCostFactory(), this.ctx);
            planner.setExecutor(this.rexExecutor);
            this.planner = planner;
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
        return this.planner;
    }

    public String dump() {
        StringWriter w = new StringWriter();
        ((VolcanoPlanner)this.planner).dump(new PrintWriter(w));
        return w.toString();
    }

    private SqlValidator validator() {
        if (this.validator == null) {
            this.validator = new IgniteSqlValidator(this.operatorTbl, this.catalogReader, this.typeFactory, this.validatorCfg, this.ctx.parameters());
        }
        return this.validator;
    }

    RelOptCluster cluster() {
        if (this.cluster == null) {
            this.cluster = RelOptCluster.create((RelOptPlanner)this.planner(), (RexBuilder)this.ctx.rexBuilder());
            this.cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(IgniteMetadata.METADATA_PROVIDER, this.planner()));
            this.cluster.setMetadataQuerySupplier(RelMetadataQueryEx::create);
        }
        return this.cluster;
    }

    private List<RelOptLattice> latices() {
        return ImmutableList.of();
    }

    private List<RelOptMaterialization> materializations() {
        return ImmutableList.of();
    }

    public RelRoot trimUnusedFields(RelRoot root) {
        SqlToRelConverter.Config cfg = this.sqlToRelConverterCfg.withExpand(false).withTrimUnusedFields(RelOptUtil.countJoins((RelNode)root.rel) < 2);
        SqlToRelConverter converter = this.sqlToRelConverter(this.validator(), this.catalogReader, cfg);
        boolean ordered = !root.collation.getFieldCollations().isEmpty();
        boolean dml = SqlKind.DML.contains(root.kind);
        return root.withRel(converter.trimUnusedFields(dml || ordered, root.rel));
    }

    public RelNode replaceCorrelatesCollisions(RelNode rel) {
        RelHomogeneousShuttle relShuttle = new RelHomogeneousShuttle(){
            private final Set<CorrelationId> usedSet = new HashSet<CorrelationId>();
            private final Map<CorrelationId, CorrelationId> replaceMap = new HashMap<CorrelationId, CorrelationId>();
            private final Map<CorrelationId, Integer> removeMap = new HashMap<CorrelationId, Integer>();
            private final RexShuttle rexShuttle = new RexShuttle(){

                public RexNode visitCorrelVariable(RexCorrelVariable variable) {
                    CorrelationId newCorId = replaceMap.get(variable.id);
                    if (newCorId != null) {
                        return IgnitePlanner.this.cluster().getRexBuilder().makeCorrel(variable.getType(), newCorId);
                    }
                    return variable;
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RelNode visit(LogicalCorrelate correlate) {
                CorrelationId corId = correlate.getCorrelationId();
                if (this.usedSet.contains(corId)) {
                    if (this.removeMap.containsKey(corId)) {
                        LogicalJoin join = LogicalJoin.create((RelNode)correlate.getLeft(), (RelNode)correlate.getRight(), Collections.emptyList(), (RexNode)IgnitePlanner.this.cluster().getRexBuilder().makeLiteral(true), Collections.emptySet(), (JoinRelType)correlate.getJoinType());
                        return super.visit((RelNode)join);
                    }
                    CorrelationId newCorId = IgnitePlanner.this.cluster().createCorrel();
                    CorrelationId oldCorId = this.replaceMap.put(corId, newCorId);
                    try {
                        correlate = correlate.copy(correlate.getTraitSet(), correlate.getLeft(), correlate.getRight(), newCorId, correlate.getRequiredColumns(), correlate.getJoinType());
                        RelNode relNode = this.visitLeftAndRightCorrelateHands(correlate, corId);
                        return relNode;
                    }
                    finally {
                        if (oldCorId == null) {
                            this.replaceMap.remove(corId);
                        } else {
                            this.replaceMap.put(corId, oldCorId);
                        }
                    }
                }
                this.usedSet.add(corId);
                return this.visitLeftAndRightCorrelateHands(correlate, corId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RelNode visitLeftAndRightCorrelateHands(LogicalCorrelate correlate, CorrelationId corId) {
                LogicalCorrelate node = correlate;
                node = this.visitChild((RelNode)node, 0, correlate.getLeft());
                this.removeMap.compute(corId, (k, v) -> v == null ? 1 : v + 1);
                try {
                    node = this.visitChild((RelNode)node, 1, correlate.getRight());
                }
                finally {
                    this.removeMap.compute(corId, (k, v) -> v == 1 ? null : Integer.valueOf(v - 1));
                }
                return node;
            }

            public RelNode visit(RelNode other) {
                RelNode next = super.visit(other);
                return this.replaceMap.isEmpty() ? next : next.accept(this.rexShuttle);
            }
        };
        return relShuttle.visit(rel);
    }

    private SqlToRelConverter sqlToRelConverter(SqlValidator validator, CalciteCatalogReader reader, SqlToRelConverter.Config config) {
        return new IgniteSqlToRelConvertor(this, validator, (Prepare.CatalogReader)reader, this.cluster(), this.convertletTbl, config);
    }

    public void setDisabledRules(Collection<String> disabledRuleNames) {
        if (F.isEmpty(disabledRuleNames)) {
            return;
        }
        this.ctx.rulesFilter(rulesSet -> {
            ArrayList<RelOptRule> newSet = new ArrayList<RelOptRule>();
            for (RelOptRule r : rulesSet) {
                if (disabledRuleNames.contains(IgnitePlanner.shortRuleName(r.toString()))) continue;
                newSet.add(r);
            }
            return RuleSets.ofList(newSet);
        });
    }

    private static String shortRuleName(String ruleDesc) {
        int pos = ruleDesc.indexOf(40);
        if (pos == -1) {
            return ruleDesc;
        }
        return ruleDesc.substring(0, pos);
    }

    private static class VolcanoPlannerExt
    extends VolcanoPlanner {
        protected VolcanoPlannerExt(RelOptCostFactory costFactory, Context externalCtx) {
            super(costFactory, externalCtx);
            this.setTopDownOpt(true);
        }

        public RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
            return mq.getCumulativeCost(rel);
        }

        public void checkCancel() {
            PlanningContext ctx = (PlanningContext)this.getContext().unwrap(PlanningContext.class);
            long timeout = ctx.plannerTimeout();
            if (timeout > 0L) {
                long startTs = ctx.startTs();
                if (U.currentTimeMillis() - startTs > timeout) {
                    this.cancelFlag.set(true);
                }
            }
            super.checkCancel();
        }
    }
}

