/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.yardstick.jdbc.AbstractNativeBenchmark;
import org.apache.ignite.yardstick.jdbc.SelectCommand;
import org.yardstickframework.BenchmarkConfiguration;

public class NativeSqlQueryRangeBenchmark
extends AbstractNativeBenchmark {
    private SelectCommand select;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.select = this.args.selectCommand();
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long expRsSize;
        long id;
        SqlFieldsQuery qry;
        if (this.args.sqlRange() == 1) {
            qry = new SqlFieldsQuery(this.select.selectOne());
            id = ThreadLocalRandom.current().nextLong(this.args.range()) + 1L;
            qry.setArgs(new Object[]{this.select.fieldByPK(id)});
            expRsSize = 1L;
        } else {
            qry = new SqlFieldsQuery(this.select.selectRange());
            id = ThreadLocalRandom.current().nextLong(this.args.range() - this.args.sqlRange()) + 1L;
            long maxId = id + (long)this.args.sqlRange() - 1L;
            qry.setArgs(new Object[]{this.select.fieldByPK(id), this.select.fieldByPK(maxId)});
            expRsSize = this.args.sqlRange();
        }
        long rsSize = 0L;
        try (FieldsQueryCursor cursor = ((IgniteEx)this.ignite()).context().query().querySqlFields(qry, false);){
            for (List row : cursor) {
                if ((Long)row.get(0) + 1L != (Long)row.get(1)) {
                    throw new Exception("Invalid result retrieved");
                }
                ++rsSize;
            }
        }
        if (rsSize != expRsSize) {
            throw new Exception("Invalid result set size [actual=" + rsSize + ", expected=" + expRsSize + "]");
        }
        return true;
    }
}

