/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.w3c.tidy.Tidy;

public class JTidyTask
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private File destdir;
    private File destfile;
    private File srcfile;
    private boolean failonerror;
    private boolean flatten;
    private Tidy tidy;
    private Properties props;
    private File properties;

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setSrcfile(File srcfile) {
        this.srcfile = srcfile;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setProperties(File properties) {
        this.properties = properties;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void addConfiguredParameter(Parameter prop) {
        this.props.setProperty(prop.getName(), prop.getValue());
    }

    public void init() {
        super.init();
        this.tidy = new Tidy();
        this.props = new Properties();
    }

    protected void validateParameters() {
        if (this.srcfile == null && this.filesets.isEmpty()) {
            throw new BuildException("Specify at least srcfile or a fileset.");
        }
        if (this.srcfile != null && !this.filesets.isEmpty()) {
            throw new BuildException("You can't specify both srcfile and nested filesets.");
        }
        if (this.destfile == null && this.destdir == null) {
            throw new BuildException("One of destfile or destdir must be set.");
        }
        if (this.srcfile == null && this.destfile != null) {
            throw new BuildException("You only can use destfile with srcfile.");
        }
        if (this.srcfile != null && this.srcfile.isDirectory()) {
            throw new BuildException("srcfile can't be a directory.");
        }
        if (this.properties != null && (!this.properties.exists() || this.properties.isDirectory())) {
            throw new BuildException("Invalid properties file specified: " + this.properties.getPath());
        }
    }

    public void execute() {
        this.validateParameters();
        if (this.properties != null) {
            try {
                this.props.load(new FileInputStream(this.properties));
            }
            catch (IOException e) {
                throw new BuildException("Unable to load properties file " + this.properties, (Throwable)e);
            }
        }
        this.tidy.setErrout(new PrintWriter(new ByteArrayOutputStream()));
        this.tidy.setConfigurationFromProps(this.props);
        if (this.srcfile != null) {
            this.executeSingle();
        } else {
            this.executeSet();
        }
    }

    protected void executeSingle() {
        if (!this.srcfile.exists()) {
            throw new BuildException("Could not find source file " + this.srcfile.getAbsolutePath() + ".");
        }
        if (this.destfile == null) {
            this.destfile = new File(this.destdir, this.srcfile.getName());
        }
        this.processFile(this.srcfile, this.destfile);
    }

    protected void executeSet() {
        FlatFileNameMapper mapper = this.flatten ? new FlatFileNameMapper() : new IdentityMapper();
        mapper.setTo(this.destdir.getAbsolutePath());
        for (FileSet fileSet : this.filesets) {
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] sourceFiles = directoryScanner.getIncludedFiles();
            File inputdir = directoryScanner.getBasedir();
            mapper.setFrom(inputdir.getAbsolutePath());
            for (String sourceFile : sourceFiles) {
                String[] mapped = mapper.mapFileName(sourceFile);
                this.processFile(new File(inputdir, sourceFile), new File(this.destdir, mapped[0]));
            }
        }
    }

    protected void processFile(File inputFile, File outputFile) {
        this.log("Processing " + inputFile.getAbsolutePath(), 4);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(inputFile));){
            if (!outputFile.getParentFile().mkdirs() || !outputFile.createNewFile()) {
                this.log("Existing output file " + outputFile, 4);
            }
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));){
                this.tidy.parse((InputStream)is, (OutputStream)os);
            }
            catch (IOException e) {
                throw new BuildException("Unable to process destination file " + outputFile, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new BuildException("Unable to open file " + inputFile, (Throwable)e);
        }
        if (this.tidy.getParseErrors() > 0 && !this.tidy.getForceOutput()) {
            try {
                Files.delete(outputFile.toPath());
            }
            catch (IOException e) {
                throw new BuildException("Failed trying to delete output file " + outputFile, (Throwable)e);
            }
        }
        if (this.failonerror && this.tidy.getParseErrors() > 0) {
            throw new BuildException("Tidy was unable to process file " + inputFile + ", " + this.tidy.getParseErrors() + " returned.");
        }
    }
}

