/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.CachedSupplier;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.telemetry.internals.ClientTelemetrySender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public class NetworkClientDelegate
implements AutoCloseable {
    private final KafkaClient client;
    private final Time time;
    private final Logger log;
    private final int requestTimeoutMs;
    private final Queue<UnsentRequest> unsentRequests;
    private final long retryBackoffMs;

    public NetworkClientDelegate(Time time, ConsumerConfig config, LogContext logContext, KafkaClient client) {
        this.time = time;
        this.client = client;
        this.log = logContext.logger(this.getClass());
        this.unsentRequests = new ArrayDeque<UnsentRequest>();
        this.requestTimeoutMs = config.getInt("request.timeout.ms");
        this.retryBackoffMs = config.getLong("retry.backoff.ms");
    }

    Queue<UnsentRequest> unsentRequests() {
        return this.unsentRequests;
    }

    public boolean isUnavailable(Node node) {
        return NetworkClientUtils.isUnavailable(this.client, node, this.time);
    }

    public void maybeThrowAuthFailure(Node node) {
        NetworkClientUtils.maybeThrowAuthFailure(this.client, node);
    }

    public void tryConnect(Node node) {
        NetworkClientUtils.tryConnect(this.client, node, this.time);
    }

    public void poll(long timeoutMs, long currentTimeMs) {
        this.trySend(currentTimeMs);
        long pollTimeoutMs = timeoutMs;
        if (!this.unsentRequests.isEmpty()) {
            pollTimeoutMs = Math.min(this.retryBackoffMs, pollTimeoutMs);
        }
        this.client.poll(pollTimeoutMs, currentTimeMs);
        this.checkDisconnects(currentTimeMs);
    }

    private void trySend(long currentTimeMs) {
        Iterator iterator = this.unsentRequests.iterator();
        while (iterator.hasNext()) {
            UnsentRequest unsent = (UnsentRequest)iterator.next();
            unsent.timer.update(currentTimeMs);
            if (unsent.timer.isExpired()) {
                iterator.remove();
                unsent.handler.onFailure(currentTimeMs, new TimeoutException("Failed to send request after " + unsent.timer.timeoutMs() + " ms."));
                continue;
            }
            if (!this.doSend(unsent, currentTimeMs)) continue;
            iterator.remove();
        }
    }

    boolean doSend(UnsentRequest r, long currentTimeMs) {
        Node node = r.node.orElse(this.client.leastLoadedNode(currentTimeMs));
        if (node == null || this.nodeUnavailable(node)) {
            this.log.debug("No broker available to send the request: {}. Retrying.", (Object)r);
            return false;
        }
        ClientRequest request = this.makeClientRequest(r, node, currentTimeMs);
        if (!this.client.ready(node, currentTimeMs)) {
            this.log.debug("Node is not ready, handle the request in the next event loop: node={}, request={}", (Object)node, (Object)r);
            return false;
        }
        this.client.send(request, currentTimeMs);
        return true;
    }

    protected void checkDisconnects(long currentTimeMs) {
        Iterator iter = this.unsentRequests.iterator();
        while (iter.hasNext()) {
            UnsentRequest u = (UnsentRequest)iter.next();
            if (!u.node.isPresent() || !this.client.connectionFailed((Node)u.node.get())) continue;
            iter.remove();
            AuthenticationException authenticationException = this.client.authenticationException((Node)u.node.get());
            u.handler.onFailure(currentTimeMs, authenticationException);
        }
    }

    private ClientRequest makeClientRequest(UnsentRequest unsent, Node node, long currentTimeMs) {
        return this.client.newClientRequest(node.idString(), unsent.requestBuilder, currentTimeMs, true, (int)unsent.timer.remainingMs(), unsent.handler);
    }

    public Node leastLoadedNode() {
        return this.client.leastLoadedNode(this.time.milliseconds());
    }

    public void wakeup() {
        this.client.wakeup();
    }

    public boolean nodeUnavailable(Node node) {
        return this.client.connectionFailed(node) && this.client.connectionDelay(node, this.time.milliseconds()) > 0L;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public long addAll(PollResult pollResult) {
        Objects.requireNonNull(pollResult);
        this.addAll(pollResult.unsentRequests);
        return pollResult.timeUntilNextPollMs;
    }

    public void addAll(List<UnsentRequest> requests) {
        Objects.requireNonNull(requests);
        if (!requests.isEmpty()) {
            requests.forEach(this::add);
        }
    }

    public void add(UnsentRequest r) {
        Objects.requireNonNull(r);
        r.setTimer(this.time, this.requestTimeoutMs);
        this.unsentRequests.add(r);
    }

    public static Supplier<NetworkClientDelegate> supplier(final Time time, final LogContext logContext, final ConsumerMetadata metadata, final ConsumerConfig config, final ApiVersions apiVersions, final Metrics metrics, final FetchMetricsManager fetchMetricsManager, final ClientTelemetrySender clientTelemetrySender) {
        return new CachedSupplier<NetworkClientDelegate>(){

            @Override
            protected NetworkClientDelegate create() {
                NetworkClient client = ClientUtils.createNetworkClient(config, metrics, "consumer", logContext, apiVersions, time, 100, metadata, fetchMetricsManager.throttleTimeSensor(), clientTelemetrySender);
                return new NetworkClientDelegate(time, config, logContext, client);
            }
        };
    }

    public static class FutureCompletionHandler
    implements RequestCompletionHandler {
        private long responseCompletionTimeMs;
        private final CompletableFuture<ClientResponse> future = new CompletableFuture();

        FutureCompletionHandler() {
        }

        public void onFailure(long currentTimeMs, RuntimeException e) {
            this.responseCompletionTimeMs = currentTimeMs;
            if (e != null) {
                this.future.completeExceptionally(e);
            } else {
                this.future.completeExceptionally(DisconnectException.INSTANCE);
            }
        }

        public long completionTimeMs() {
            return this.responseCompletionTimeMs;
        }

        @Override
        public void onComplete(ClientResponse response) {
            long completionTimeMs = response.receivedTimeMs();
            if (response.authenticationException() != null) {
                this.onFailure(completionTimeMs, response.authenticationException());
            } else if (response.wasDisconnected()) {
                this.onFailure(completionTimeMs, DisconnectException.INSTANCE);
            } else if (response.versionMismatch() != null) {
                this.onFailure(completionTimeMs, response.versionMismatch());
            } else {
                this.responseCompletionTimeMs = completionTimeMs;
                this.future.complete(response);
            }
        }

        public CompletableFuture<ClientResponse> future() {
            return this.future;
        }
    }

    public static class UnsentRequest {
        private final AbstractRequest.Builder<?> requestBuilder;
        private final FutureCompletionHandler handler;
        private final Optional<Node> node;
        private Timer timer;

        public UnsentRequest(AbstractRequest.Builder<?> requestBuilder, Optional<Node> node) {
            Objects.requireNonNull(requestBuilder);
            this.requestBuilder = requestBuilder;
            this.node = node;
            this.handler = new FutureCompletionHandler();
        }

        void setTimer(Time time, long requestTimeoutMs) {
            this.timer = time.timer(requestTimeoutMs);
        }

        Timer timer() {
            return this.timer;
        }

        CompletableFuture<ClientResponse> future() {
            return this.handler.future;
        }

        FutureCompletionHandler handler() {
            return this.handler;
        }

        UnsentRequest whenComplete(BiConsumer<ClientResponse, Throwable> callback) {
            this.handler.future().whenComplete((BiConsumer)callback);
            return this;
        }

        AbstractRequest.Builder<?> requestBuilder() {
            return this.requestBuilder;
        }

        Optional<Node> node() {
            return this.node;
        }

        public String toString() {
            return "UnsentRequest{requestBuilder=" + this.requestBuilder + ", handler=" + this.handler + ", node=" + this.node + ", timer=" + this.timer + '}';
        }
    }

    public static class PollResult {
        public static final long WAIT_FOREVER = Long.MAX_VALUE;
        public static final PollResult EMPTY = new PollResult(Long.MAX_VALUE);
        public final long timeUntilNextPollMs;
        public final List<UnsentRequest> unsentRequests;

        public PollResult(long timeUntilNextPollMs, List<UnsentRequest> unsentRequests) {
            this.timeUntilNextPollMs = timeUntilNextPollMs;
            this.unsentRequests = Collections.unmodifiableList(unsentRequests);
        }

        public PollResult(List<UnsentRequest> unsentRequests) {
            this(Long.MAX_VALUE, unsentRequests);
        }

        public PollResult(UnsentRequest unsentRequest) {
            this(Collections.singletonList(unsentRequest));
        }

        public PollResult(long timeUntilNextPollMs) {
            this(timeUntilNextPollMs, Collections.emptyList());
        }
    }
}

