/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.health;

import com.ecwid.consul.ConsulRequest;
import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.v1.NodeMetaParameters;
import com.ecwid.consul.v1.QueryParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class HealthChecksForServiceRequest
implements ConsulRequest {
    private final String datacenter;
    private final String near;
    private final Map<String, String> nodeMeta;
    private final QueryParams queryParams;

    public HealthChecksForServiceRequest(String datacenter, String near, Map<String, String> nodeMeta, QueryParams queryParams) {
        this.datacenter = datacenter;
        this.near = near;
        this.nodeMeta = nodeMeta;
        this.queryParams = queryParams;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getNear() {
        return this.near;
    }

    public Map<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    public QueryParams getQueryParams() {
        return this.queryParams;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public List<UrlParameters> asUrlParameters() {
        ArrayList<UrlParameters> params = new ArrayList<UrlParameters>();
        if (this.datacenter != null) {
            params.add(new SingleUrlParameters("dc", this.datacenter));
        }
        if (this.near != null) {
            params.add(new SingleUrlParameters("near", this.near));
        }
        if (this.nodeMeta != null) {
            params.add(new NodeMetaParameters(this.nodeMeta));
        }
        if (this.queryParams != null) {
            params.add(this.queryParams);
        }
        return params;
    }

    public static class Builder {
        private String datacenter;
        private String near;
        private Map<String, String> nodeMeta;
        private QueryParams queryParams;

        private Builder() {
        }

        public Builder setDatacenter(String datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public Builder setNear(String near) {
            this.near = near;
            return this;
        }

        public Builder setNodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = nodeMeta != null ? Collections.unmodifiableMap(nodeMeta) : null;
            return this;
        }

        public Builder setQueryParams(QueryParams queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public HealthChecksForServiceRequest build() {
            return new HealthChecksForServiceRequest(this.datacenter, this.near, this.nodeMeta, this.queryParams);
        }
    }
}

