/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.dao.AlertGroupConvergeDao;
import org.apache.hertzbeat.alert.reduce.AlarmInhibitReduce;
import org.apache.hertzbeat.common.entity.alerter.AlertGroupConverge;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlarmGroupReduce {
    private static final Logger log = LoggerFactory.getLogger(AlarmGroupReduce.class);
    private static final long DEFAULT_GROUP_WAIT = 30000L;
    private static final long DEFAULT_GROUP_INTERVAL = 300000L;
    private static final long DEFAULT_REPEAT_INTERVAL = 14400000L;
    private static final long MS_PER_SECOND = 1000L;
    private static final long CHECK_INTERVAL = 1000L;
    private final AlarmInhibitReduce alarmInhibitReduce;
    private final Map<String, AlertGroupConverge> groupDefines;
    private final Map<String, GroupAlertCache> groupCacheMap;

    public AlarmGroupReduce(AlarmInhibitReduce alarmInhibitReduce, AlertGroupConvergeDao alertGroupConvergeDao) {
        this.alarmInhibitReduce = alarmInhibitReduce;
        this.groupDefines = new ConcurrentHashMap<String, AlertGroupConverge>(8);
        this.groupCacheMap = new ConcurrentHashMap<String, GroupAlertCache>(8);
        List<AlertGroupConverge> groupConverges = alertGroupConvergeDao.findAlertGroupConvergesByEnableIsTrue();
        this.refreshGroupDefines(groupConverges);
        this.startCheckAndSendGroups();
    }

    private void startCheckAndSendGroups() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Check alarm groups calculate has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("alarm-group-calculate-%d").build();
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        scheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                long now = System.currentTimeMillis();
                this.groupCacheMap.forEach((groupKey, cache) -> {
                    if (this.shouldSendGroup((GroupAlertCache)cache, now)) {
                        this.sendGroupAlert((GroupAlertCache)cache);
                        cache.setLastSendTime(now);
                        cache.getAlertFingerprints().clear();
                    }
                });
            }
            catch (Exception e) {
                log.error("Check alarm groups calculate has exception.: {}", (Object)e.getMessage(), (Object)e);
            }
        }, 10000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void refreshGroupDefines(List<AlertGroupConverge> groupDefines) {
        this.groupDefines.clear();
        groupDefines.forEach(define -> this.groupDefines.put(define.getName(), (AlertGroupConverge)define));
    }

    public void processGroupAlert(SingleAlert alert) {
        Map labels = alert.getLabels();
        if (labels == null || labels.isEmpty() || this.groupDefines.isEmpty()) {
            this.sendSingleAlert(alert);
            return;
        }
        boolean matched = false;
        for (Map.Entry<String, AlertGroupConverge> define : this.groupDefines.entrySet()) {
            String defineName = define.getKey();
            AlertGroupConverge ruleConfig = define.getValue();
            if (!this.hasRequiredLabels(labels, ruleConfig.getGroupLabels())) continue;
            matched = true;
            this.processAlertByGroupDefine(alert, defineName, ruleConfig);
        }
        if (!matched) {
            this.sendSingleAlert(alert);
        }
    }

    private boolean hasRequiredLabels(Map<String, String> labels, List<String> requiredLabels) {
        return requiredLabels.stream().allMatch(labels::containsKey);
    }

    private void processAlertByGroupDefine(SingleAlert alert, String defineName, AlertGroupConverge ruleConfig) {
        HashMap<String, String> extractedLabels = new HashMap<String, String>();
        for (String labelKey : ruleConfig.getGroupLabels()) {
            extractedLabels.put(labelKey, (String)alert.getLabels().get(labelKey));
        }
        String groupKey = this.generateGroupKey(extractedLabels);
        GroupAlertCache cache = this.groupCacheMap.computeIfAbsent(groupKey, k -> {
            GroupAlertCache newCache = new GroupAlertCache();
            newCache.setGroupKey(groupKey);
            newCache.setGroupLabels(extractedLabels);
            newCache.setGroupDefineName(defineName);
            newCache.setCreateTime(System.currentTimeMillis());
            newCache.setAlertFingerprints(new ConcurrentHashMap<String, SingleAlert>(8));
            return newCache;
        });
        String fingerprint = alert.getFingerprint();
        SingleAlert existingAlert = cache.getAlertFingerprints().get(fingerprint);
        if (existingAlert != null) {
            alert.setStartAt(existingAlert.getStartAt());
            cache.getAlertFingerprints().put(fingerprint, alert);
            return;
        }
        cache.getAlertFingerprints().put(fingerprint, alert);
        if (this.shouldSendGroupImmediately(cache)) {
            this.sendGroupAlert(cache);
            cache.setLastSendTime(System.currentTimeMillis());
            cache.getAlertFingerprints().clear();
        }
    }

    private void sendGroupAlert(GroupAlertCache cache) {
        if (cache.getAlertFingerprints().isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        String status = this.determineGroupStatus(cache.getAlertFingerprints().values());
        if ("firing".equals(status)) {
            long repeatInterval;
            AlertGroupConverge ruleConfig = this.groupDefines.get(cache.getGroupDefineName());
            long l = repeatInterval = ruleConfig.getRepeatInterval() != null ? ruleConfig.getRepeatInterval() * 1000L : 14400000L;
            if (cache.getLastRepeatTime() > 0L && now - cache.getLastRepeatTime() < repeatInterval) {
                return;
            }
            cache.setLastRepeatTime(now);
        }
        GroupAlert groupAlert = GroupAlert.builder().groupKey(cache.getGroupKey()).groupLabels(cache.getGroupLabels()).commonLabels(this.extractCommonLabels(cache.getAlertFingerprints().values())).commonAnnotations(this.extractCommonAnnotations(cache.getAlertFingerprints().values())).alerts(new ArrayList<SingleAlert>(cache.getAlertFingerprints().values())).status(status).build();
        this.alarmInhibitReduce.inhibitAlarm(groupAlert);
    }

    private boolean shouldSendGroup(GroupAlertCache cache, long now) {
        long groupInterval;
        AlertGroupConverge ruleConfig = this.groupDefines.get(cache.getGroupDefineName());
        long groupWait = ruleConfig != null ? ruleConfig.getGroupWait() * 1000L : 30000L;
        long l = groupInterval = ruleConfig != null ? ruleConfig.getGroupInterval() * 1000L : 300000L;
        if (cache.getLastSendTime() == 0L && now - cache.getCreateTime() >= groupWait) {
            return true;
        }
        return cache.getLastSendTime() > 0L && now - cache.getLastSendTime() >= groupInterval;
    }

    private boolean shouldSendGroupImmediately(GroupAlertCache cache) {
        return cache.getAlertFingerprints().values().stream().allMatch(alert -> "resolved".equals(alert.getStatus()));
    }

    private void sendSingleAlert(SingleAlert alert) {
        String groupKey = this.generateGroupKey(alert.getLabels());
        GroupAlert groupAlert = GroupAlert.builder().groupKey(groupKey).groupLabels(alert.getLabels()).commonLabels(alert.getLabels()).commonAnnotations(alert.getAnnotations()).alerts(new LinkedList<SingleAlert>(List.of(alert))).status(alert.getStatus()).build();
        this.alarmInhibitReduce.inhibitAlarm(groupAlert);
    }

    private String generateGroupKey(Map<String, String> labels) {
        return labels.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(","));
    }

    private Map<String, String> extractCommonLabels(Collection<SingleAlert> alerts) {
        if (alerts.isEmpty()) {
            return new HashMap<String, String>(8);
        }
        HashMap<String, String> common = new HashMap<String, String>(alerts.stream().findFirst().get().getLabels());
        alerts.forEach(alert -> common.keySet().removeIf(key -> !alert.getLabels().containsKey(key) || !((String)common.get(key)).equals(alert.getLabels().get(key))));
        return common;
    }

    private Map<String, String> extractCommonAnnotations(Collection<SingleAlert> alerts) {
        if (alerts.isEmpty()) {
            return new HashMap<String, String>(8);
        }
        HashMap<String, String> common = new HashMap<String, String>(alerts.stream().findFirst().get().getAnnotations());
        alerts.forEach(alert -> common.keySet().removeIf(key -> !alert.getAnnotations().containsKey(key) || !((String)common.get(key)).equals(alert.getAnnotations().get(key))));
        return common;
    }

    private String determineGroupStatus(Collection<SingleAlert> alerts) {
        return alerts.stream().anyMatch(alert -> "firing".equals(alert.getStatus())) ? "firing" : "resolved";
    }

    private static class GroupAlertCache {
        private String groupDefineName;
        private String groupKey;
        private Map<String, String> groupLabels;
        private Map<String, SingleAlert> alertFingerprints = new ConcurrentHashMap<String, SingleAlert>(8);
        private long createTime;
        private long lastSendTime;
        private long lastRepeatTime;

        public String getGroupDefineName() {
            return this.groupDefineName;
        }

        public String getGroupKey() {
            return this.groupKey;
        }

        public Map<String, String> getGroupLabels() {
            return this.groupLabels;
        }

        public Map<String, SingleAlert> getAlertFingerprints() {
            return this.alertFingerprints;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getLastSendTime() {
            return this.lastSendTime;
        }

        public long getLastRepeatTime() {
            return this.lastRepeatTime;
        }

        public void setGroupDefineName(String groupDefineName) {
            this.groupDefineName = groupDefineName;
        }

        public void setGroupKey(String groupKey) {
            this.groupKey = groupKey;
        }

        public void setGroupLabels(Map<String, String> groupLabels) {
            this.groupLabels = groupLabels;
        }

        public void setAlertFingerprints(Map<String, SingleAlert> alertFingerprints) {
            this.alertFingerprints = alertFingerprints;
        }

        public void setCreateTime(long createTime) {
            this.createTime = createTime;
        }

        public void setLastSendTime(long lastSendTime) {
            this.lastSendTime = lastSendTime;
        }

        public void setLastRepeatTime(long lastRepeatTime) {
            this.lastRepeatTime = lastRepeatTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupAlertCache)) {
                return false;
            }
            GroupAlertCache other = (GroupAlertCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCreateTime() != other.getCreateTime()) {
                return false;
            }
            if (this.getLastSendTime() != other.getLastSendTime()) {
                return false;
            }
            if (this.getLastRepeatTime() != other.getLastRepeatTime()) {
                return false;
            }
            String this$groupDefineName = this.getGroupDefineName();
            String other$groupDefineName = other.getGroupDefineName();
            if (this$groupDefineName == null ? other$groupDefineName != null : !this$groupDefineName.equals(other$groupDefineName)) {
                return false;
            }
            String this$groupKey = this.getGroupKey();
            String other$groupKey = other.getGroupKey();
            if (this$groupKey == null ? other$groupKey != null : !this$groupKey.equals(other$groupKey)) {
                return false;
            }
            Map<String, String> this$groupLabels = this.getGroupLabels();
            Map<String, String> other$groupLabels = other.getGroupLabels();
            if (this$groupLabels == null ? other$groupLabels != null : !((Object)this$groupLabels).equals(other$groupLabels)) {
                return false;
            }
            Map<String, SingleAlert> this$alertFingerprints = this.getAlertFingerprints();
            Map<String, SingleAlert> other$alertFingerprints = other.getAlertFingerprints();
            return !(this$alertFingerprints == null ? other$alertFingerprints != null : !((Object)this$alertFingerprints).equals(other$alertFingerprints));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupAlertCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $createTime = this.getCreateTime();
            result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
            long $lastSendTime = this.getLastSendTime();
            result = result * 59 + (int)($lastSendTime >>> 32 ^ $lastSendTime);
            long $lastRepeatTime = this.getLastRepeatTime();
            result = result * 59 + (int)($lastRepeatTime >>> 32 ^ $lastRepeatTime);
            String $groupDefineName = this.getGroupDefineName();
            result = result * 59 + ($groupDefineName == null ? 43 : $groupDefineName.hashCode());
            String $groupKey = this.getGroupKey();
            result = result * 59 + ($groupKey == null ? 43 : $groupKey.hashCode());
            Map<String, String> $groupLabels = this.getGroupLabels();
            result = result * 59 + ($groupLabels == null ? 43 : ((Object)$groupLabels).hashCode());
            Map<String, SingleAlert> $alertFingerprints = this.getAlertFingerprints();
            result = result * 59 + ($alertFingerprints == null ? 43 : ((Object)$alertFingerprints).hashCode());
            return result;
        }

        public String toString() {
            return "AlarmGroupReduce.GroupAlertCache(groupDefineName=" + this.getGroupDefineName() + ", groupKey=" + this.getGroupKey() + ", groupLabels=" + this.getGroupLabels() + ", alertFingerprints=" + this.getAlertFingerprints() + ", createTime=" + this.getCreateTime() + ", lastSendTime=" + this.getLastSendTime() + ", lastRepeatTime=" + this.getLastRepeatTime() + ")";
        }
    }
}

