/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.filesystem;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.flywaydb.core.internal.resource.filesystem.FlywayEncodingDetectionException;

public class EncodingDetector {
    private static final int UTF16BigEndianHeaderByte1 = 254;
    private static final int UTF16BigEndianHeaderByte2 = 255;
    private static final int UTF16LittleEndianHeaderByte1 = 255;
    private static final int UTF16LittleEndianHeaderByte2 = 254;
    private static final String[] detectableCharsets = new String[]{StandardCharsets.UTF_8.toString(), StandardCharsets.ISO_8859_1.toString(), StandardCharsets.UTF_16.toString()};

    public static Charset detectFileEncoding(Path path) throws FlywayEncodingDetectionException {
        try {
            byte[] buffer = EncodingDetector.readAllBytesFromPath(path);
            Charset charset = EncodingDetector.detectCharset(buffer);
            if (charset == null) {
                throw new FlywayEncodingDetectionException("Could not detect charset for " + path);
            }
            return charset;
        }
        catch (Exception e) {
            throw new FlywayEncodingDetectionException("Could not detect encoding for " + path, e);
        }
    }

    private static byte[] readAllBytesFromPath(Path path) {
        try {
            return Files.readAllBytes(path.toAbsolutePath());
        }
        catch (Exception e) {
            throw new FlywayEncodingDetectionException("Could not detect encoding for " + path + " as the file could not be read", e);
        }
    }

    private static Charset detectCharset(byte[] buffer) {
        Charset charset = EncodingDetector.readCharsetHeader(buffer);
        if (charset != null) {
            return charset;
        }
        for (String charsetName : detectableCharsets) {
            Charset detectingCharset = Charset.forName(charsetName);
            if (!EncodingDetector.canCorrectlyDecodeBufferWithNamedCharset(buffer, detectingCharset)) continue;
            charset = detectingCharset;
            break;
        }
        if (charset != StandardCharsets.UTF_16 && charset != StandardCharsets.UTF_16BE && charset != StandardCharsets.UTF_16LE && EncodingDetector.isLikelyToBeUTF16(buffer)) {
            charset = StandardCharsets.UTF_16;
        }
        return charset;
    }

    private static Charset readCharsetHeader(byte[] buffer) {
        if (buffer.length < 2) {
            return null;
        }
        if (buffer.length % 2 != 0) {
            return null;
        }
        int headerByte1 = Byte.toUnsignedInt(buffer[0]);
        int headerByte2 = Byte.toUnsignedInt(buffer[1]);
        if (254 == headerByte1 && 255 == headerByte2) {
            return StandardCharsets.UTF_16BE;
        }
        if (255 == headerByte1 && 254 == headerByte2) {
            return StandardCharsets.UTF_16LE;
        }
        return null;
    }

    private static boolean isLikelyToBeUTF16(byte[] buffer) {
        if (buffer.length % 2 != 0) {
            return false;
        }
        int matchCount = 0;
        for (int i = 1; i < buffer.length; i += 2) {
            boolean oddIndexedByteIsZero;
            boolean bl = oddIndexedByteIsZero = Byte.toUnsignedInt(buffer[i]) == 0;
            if (oddIndexedByteIsZero) {
                ++matchCount;
                continue;
            }
            --matchCount;
        }
        return matchCount > 0;
    }

    private static boolean canCorrectlyDecodeBufferWithNamedCharset(byte[] buffer, Charset charset) {
        try {
            charset.newDecoder().decode(ByteBuffer.wrap(buffer));
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }
}

