/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.util;

import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public class SurenessCommonUtil {
    private static final String USER_AGENT = "User-Agent";
    private static final String UNKNOWN = "unknown";
    private static final String ANDROID = "Android";
    private static final String LINUX = "Linux";
    private static final String IPHONE = "iPhone";
    private static final String WINDOWS = "Windows";
    private static final String CHROME = "Chrome";
    private static final String PATH_SPLIT = "/";
    private static final String RANDOM_CHAR = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final Random RANDOM = new Random();

    public static String findUserAgent(String userAgent) {
        userAgent = userAgent == null || "".equals(userAgent) ? UNKNOWN : (userAgent.contains(ANDROID) ? ANDROID : (userAgent.contains(LINUX) ? LINUX : (userAgent.contains(IPHONE) ? IPHONE : (userAgent.contains(WINDOWS) ? WINDOWS : (userAgent.contains(CHROME) ? CHROME : UNKNOWN)))));
        return userAgent;
    }

    public static String getRandomString(int length) {
        if (length < 1) {
            length = 6;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = RANDOM.nextInt(RANDOM_CHAR.length());
            sb.append(RANDOM_CHAR.charAt(number));
        }
        return sb.toString();
    }

    public static Set<String> attachContextPath(String contextPath, Set<String> uriResource) {
        if (contextPath == null || "".equals(contextPath) || uriResource == null || uriResource.isEmpty()) {
            return uriResource;
        }
        contextPath = contextPath.toLowerCase().trim();
        if (!(contextPath = contextPath.replace("//", PATH_SPLIT)).startsWith(PATH_SPLIT)) {
            contextPath = PATH_SPLIT.concat(contextPath);
        }
        if (contextPath.endsWith(PATH_SPLIT)) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        String finalContextPath = contextPath;
        return uriResource.stream().map(resource -> resource.startsWith(PATH_SPLIT) ? finalContextPath.concat((String)resource) : finalContextPath.concat(PATH_SPLIT).concat((String)resource)).collect(Collectors.toSet());
    }
}

