/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.support;

import com.usthe.sureness.subject.PrincipalMap;
import com.usthe.sureness.subject.Subject;
import java.util.List;

public class DigestSubject
implements Subject {
    private static final long serialVersionUID = 1L;
    private String appId;
    private String realm;
    private String uri;
    private String qop;
    private String nonce;
    private String nc;
    private String cnonce;
    private String response;
    private String httpMethod;
    private String remoteHost;
    private List<String> ownRoles;
    private String targetUri;
    private List<String> supportRoles;
    private PrincipalMap principalMap;

    public DigestSubject() {
    }

    private DigestSubject(Builder builder) {
        this.appId = builder.appId;
        this.response = builder.response;
        this.realm = builder.realm;
        this.uri = builder.uri;
        this.qop = builder.qop;
        this.nonce = builder.nonce;
        this.nc = builder.nc;
        this.cnonce = builder.cnonce;
        this.httpMethod = builder.httpMethod;
        this.remoteHost = builder.remoteHost;
        this.ownRoles = builder.ownRoles;
        this.targetUri = builder.targetUri;
        this.supportRoles = builder.supportRoles;
        this.principalMap = builder.principalMap;
    }

    @Override
    public Object getPrincipal() {
        return this.appId;
    }

    @Override
    public void setPrincipal(Object var1) {
        this.appId = (String)var1;
    }

    @Override
    public PrincipalMap getPrincipalMap() {
        return this.principalMap;
    }

    @Override
    public void setPrincipalMap(PrincipalMap var1) {
        this.principalMap = var1;
    }

    @Override
    public Object getCredential() {
        return this.response;
    }

    @Override
    public void setCredential(Object var1) {
        this.response = (String)var1;
    }

    @Override
    public Object getOwnRoles() {
        return this.ownRoles;
    }

    @Override
    public void setOwnRoles(Object var1) {
        this.ownRoles = (List)var1;
    }

    @Override
    public Object getTargetResource() {
        return this.targetUri;
    }

    @Override
    public void setTargetResource(Object var1) {
        this.targetUri = (String)var1;
    }

    @Override
    public Object getSupportRoles() {
        return this.supportRoles;
    }

    @Override
    public void setSupportRoles(Object var1) {
        this.supportRoles = (List)var1;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUri() {
        return this.uri;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getNc() {
        return this.nc;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public static Builder builder(String username, String response) {
        return new Builder(username, response);
    }

    public static Builder builder(Subject subject) {
        return new Builder(subject);
    }

    public static class Builder {
        private String appId;
        private String response;
        private String realm;
        private String uri;
        private String qop;
        private String nonce;
        private String nc;
        private String cnonce;
        private String httpMethod;
        private String remoteHost;
        private List<String> ownRoles;
        private String targetUri;
        private List<String> supportRoles;
        private PrincipalMap principalMap;

        public Builder(String username, String response) {
            this.appId = username;
            this.response = response;
        }

        public Builder(Subject subject) {
            this.appId = String.valueOf(subject.getPrincipal());
            this.response = String.valueOf(subject.getCredential());
            this.ownRoles = (List)subject.getOwnRoles();
            this.targetUri = String.valueOf(subject.getTargetResource());
            this.supportRoles = (List)subject.getSupportRoles();
            this.principalMap = subject.getPrincipalMap();
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setResponse(String response) {
            this.response = response;
            return this;
        }

        public Builder setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setQop(String qop) {
            this.qop = qop;
            return this;
        }

        public Builder setNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder setNc(String nc) {
            this.nc = nc;
            return this;
        }

        public Builder setCnonce(String cnonce) {
            this.cnonce = cnonce;
            return this;
        }

        public Builder setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder setTargetUri(String targetUri) {
            this.targetUri = targetUri;
            return this;
        }

        public Builder setRemoteHost(String remoteHost) {
            this.remoteHost = remoteHost;
            return this;
        }

        public Builder setOwnRoles(List<String> ownRoles) {
            this.ownRoles = ownRoles;
            return this;
        }

        public Builder setSupportRoles(List<String> supportRoles) {
            this.supportRoles = supportRoles;
            return this;
        }

        public Builder setPrincipalMap(PrincipalMap principalMap) {
            this.principalMap = principalMap;
            return this;
        }

        public DigestSubject build() {
            return new DigestSubject(this);
        }
    }
}

