/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.util.JsonWebTokenUtil;
import javax.ws.rs.container.ContainerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtSubjectJaxRsCreator
implements SubjectCreate {
    private static final Logger logger = LoggerFactory.getLogger(JwtSubjectJaxRsCreator.class);

    @Override
    public boolean canSupportSubject(Object context) {
        String authorization;
        if (context instanceof ContainerRequestContext && (authorization = ((ContainerRequestContext)context).getHeaderString("Authorization")) != null && authorization.startsWith("Bearer")) {
            String jwtValue = authorization.replace("Bearer", "").trim();
            return !JsonWebTokenUtil.isNotJsonWebToken(jwtValue);
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        String authorization = ((ContainerRequestContext)context).getHeaderString("Authorization");
        if (authorization != null && authorization.startsWith("Bearer")) {
            String jwtValue = authorization.replace("Bearer", "").trim();
            if (JsonWebTokenUtil.isNotJsonWebToken(jwtValue)) {
                if (logger.isInfoEnabled()) {
                    logger.info("can not create JwtSubject by this request message, is not jwt");
                }
                return null;
            }
            String requestUri = ((ContainerRequestContext)context).getUriInfo().getPath();
            String requestType = ((ContainerRequestContext)context).getMethod();
            String targetUri = requestUri.concat("===").concat(requestType.toLowerCase());
            return JwtSubject.builder(jwtValue).setTargetResource(targetUri).build();
        }
        return null;
    }
}

