/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.util.StringUtils;

public class DefaultEmbeddingModelObservationConvention
implements EmbeddingModelObservationConvention {
    public static final String DEFAULT_NAME = "gen_ai.client.operation";
    private static final KeyValue REQUEST_MODEL_NONE = KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)"none");
    private static final KeyValue RESPONSE_MODEL_NONE = KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.RESPONSE_MODEL, (String)"none");

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getContextualName(EmbeddingModelObservationContext context) {
        if (StringUtils.hasText((String)((EmbeddingRequest)context.getRequest()).getOptions().getModel())) {
            return "%s %s".formatted(context.getOperationMetadata().operationType(), ((EmbeddingRequest)context.getRequest()).getOptions().getModel());
        }
        return context.getOperationMetadata().operationType();
    }

    public KeyValues getLowCardinalityKeyValues(EmbeddingModelObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.requestModel(context), this.responseModel(context)});
    }

    protected KeyValue aiOperationType(EmbeddingModelObservationContext context) {
        return KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)context.getOperationMetadata().operationType());
    }

    protected KeyValue aiProvider(EmbeddingModelObservationContext context) {
        return KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)context.getOperationMetadata().provider());
    }

    protected KeyValue requestModel(EmbeddingModelObservationContext context) {
        if (StringUtils.hasText((String)((EmbeddingRequest)context.getRequest()).getOptions().getModel())) {
            return KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)((EmbeddingRequest)context.getRequest()).getOptions().getModel());
        }
        return REQUEST_MODEL_NONE;
    }

    protected KeyValue responseModel(EmbeddingModelObservationContext context) {
        if (context.getResponse() != null && ((EmbeddingResponse)context.getResponse()).getMetadata() != null && StringUtils.hasText((String)((EmbeddingResponse)context.getResponse()).getMetadata().getModel())) {
            return KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.RESPONSE_MODEL, (String)((EmbeddingResponse)context.getResponse()).getMetadata().getModel());
        }
        return RESPONSE_MODEL_NONE;
    }

    public KeyValues getHighCardinalityKeyValues(EmbeddingModelObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.requestEmbeddingDimension(keyValues, context);
        keyValues = this.usageInputTokens(keyValues, context);
        keyValues = this.usageTotalTokens(keyValues, context);
        return keyValues;
    }

    protected KeyValues requestEmbeddingDimension(KeyValues keyValues, EmbeddingModelObservationContext context) {
        if (((EmbeddingRequest)context.getRequest()).getOptions().getDimensions() != null) {
            return keyValues.and(EmbeddingModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_EMBEDDING_DIMENSIONS.asString(), String.valueOf(((EmbeddingRequest)context.getRequest()).getOptions().getDimensions()));
        }
        return keyValues;
    }

    protected KeyValues usageInputTokens(KeyValues keyValues, EmbeddingModelObservationContext context) {
        if (context.getResponse() != null && ((EmbeddingResponse)context.getResponse()).getMetadata() != null && ((EmbeddingResponse)context.getResponse()).getMetadata().getUsage() != null && ((EmbeddingResponse)context.getResponse()).getMetadata().getUsage().getPromptTokens() != null) {
            return keyValues.and(EmbeddingModelObservationDocumentation.HighCardinalityKeyNames.USAGE_INPUT_TOKENS.asString(), String.valueOf(((EmbeddingResponse)context.getResponse()).getMetadata().getUsage().getPromptTokens()));
        }
        return keyValues;
    }

    protected KeyValues usageTotalTokens(KeyValues keyValues, EmbeddingModelObservationContext context) {
        if (context.getResponse() != null && ((EmbeddingResponse)context.getResponse()).getMetadata() != null && ((EmbeddingResponse)context.getResponse()).getMetadata().getUsage() != null && ((EmbeddingResponse)context.getResponse()).getMetadata().getUsage().getTotalTokens() != null) {
            return keyValues.and(EmbeddingModelObservationDocumentation.HighCardinalityKeyNames.USAGE_TOTAL_TOKENS.asString(), String.valueOf(((EmbeddingResponse)context.getResponse()).getMetadata().getUsage().getTotalTokens()));
        }
        return keyValues;
    }
}

