/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.UnsignedLong;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ClickHouseLongValue
implements ClickHouseValue {
    private boolean isNull;
    private long value;

    public static ClickHouseLongValue ofNull() {
        return ClickHouseLongValue.ofNull(null, false);
    }

    public static ClickHouseLongValue ofUnsignedNull() {
        return ClickHouseLongValue.ofNull(null, true);
    }

    public static ClickHouseLongValue ofNull(boolean unsigned) {
        return ClickHouseLongValue.ofNull(null, unsigned);
    }

    public static ClickHouseLongValue ofNull(ClickHouseValue ref, boolean unsigned) {
        if (unsigned) {
            return ref instanceof UnsignedLongValue ? ((UnsignedLongValue)ref).set(true, 0L) : new UnsignedLongValue(true, 0L);
        }
        return ref instanceof ClickHouseLongValue ? ((ClickHouseLongValue)ref).set(true, 0L) : new ClickHouseLongValue(true, 0L);
    }

    public static ClickHouseLongValue of(long value) {
        return ClickHouseLongValue.of(null, value, false);
    }

    public static ClickHouseLongValue ofUnsigned(long value) {
        return ClickHouseLongValue.of(null, value, true);
    }

    public static ClickHouseLongValue of(long value, boolean unsigned) {
        return ClickHouseLongValue.of(null, value, unsigned);
    }

    public static ClickHouseLongValue of(int value) {
        return ClickHouseLongValue.of(null, value, false);
    }

    public static ClickHouseLongValue ofUnsigned(int value) {
        return ClickHouseLongValue.of(null, 0xFFFFFFFFL & (long)value, true);
    }

    public static ClickHouseLongValue of(int value, boolean unsigned) {
        return ClickHouseLongValue.of(null, unsigned ? 0xFFFFFFFFL & (long)value : (long)value, unsigned);
    }

    public static ClickHouseLongValue of(Number value, boolean unsigned) {
        return value == null ? ClickHouseLongValue.ofNull(null, unsigned) : ClickHouseLongValue.of(null, value.longValue(), unsigned);
    }

    public static ClickHouseLongValue of(ClickHouseValue ref, long value, boolean unsigned) {
        if (unsigned) {
            return ref instanceof UnsignedLongValue ? ((UnsignedLongValue)ref).set(false, value) : new UnsignedLongValue(false, value);
        }
        return ref instanceof ClickHouseLongValue ? ((ClickHouseLongValue)ref).set(false, value) : new ClickHouseLongValue(false, value);
    }

    protected ClickHouseLongValue(boolean isNull, long value) {
        this.set(isNull, value);
    }

    protected final ClickHouseLongValue set(boolean isNull, long value) {
        this.isNull = isNull;
        this.value = isNull ? 0L : value;
        return this;
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    public ClickHouseLongValue copy(boolean deep) {
        return new ClickHouseLongValue(this.isNull, this.value);
    }

    @Override
    public final boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInteger() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNull ? null : BigDecimal.valueOf(this.value, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Long.valueOf(this.getValue());
    }

    @Override
    public String asString() {
        return this.isNull ? null : Long.toString(this.value);
    }

    @Override
    public ClickHouseLongValue resetToDefault() {
        return this.set(false, 0L);
    }

    @Override
    public ClickHouseLongValue resetToNullOrEmpty() {
        return this.set(true, 0L);
    }

    @Override
    public String toSqlExpression() {
        return this.isNull ? "NULL" : Long.toString(this.value);
    }

    @Override
    public ClickHouseLongValue update(boolean value) {
        return this.set(false, value ? 1L : 0L);
    }

    @Override
    public ClickHouseLongValue update(char value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseLongValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseLongValue update(short value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseLongValue update(int value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseLongValue update(long value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseLongValue update(float value) {
        return this.set(false, (long)value);
    }

    @Override
    public ClickHouseLongValue update(double value) {
        return this.set(false, (long)value);
    }

    @Override
    public ClickHouseLongValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.longValueExact());
    }

    @Override
    public ClickHouseLongValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.longValueExact());
    }

    @Override
    public ClickHouseLongValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.ordinal());
    }

    @Override
    public ClickHouseLongValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value.isEmpty()) {
            this.resetToDefault();
        } else {
            this.set(false, Long.parseLong(value));
        }
        return this;
    }

    @Override
    public ClickHouseLongValue update(ClickHouseValue value) {
        return value == null || value.isNullOrEmpty() ? this.resetToNullOrEmpty() : this.set(false, value.asLong());
    }

    @Override
    public ClickHouseLongValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).longValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asLong());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseLongValue v = (ClickHouseLongValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }

    static final class UnsignedLongValue
    extends ClickHouseLongValue {
        protected UnsignedLongValue(boolean isNull, long value) {
            super(isNull, value);
        }

        @Override
        public BigInteger asBigInteger() {
            if (this.isNullOrEmpty()) {
                return null;
            }
            long l = this.getValue();
            BigInteger v = BigInteger.valueOf(l);
            if (l < 0L) {
                v = v.and(UnsignedLong.MASK);
            }
            return v;
        }

        @Override
        public float asFloat() {
            return this.getValue();
        }

        @Override
        public double asDouble() {
            return this.getValue();
        }

        @Override
        public BigDecimal asBigDecimal(int scale) {
            if (this.isNullOrEmpty()) {
                return null;
            }
            long l = this.getValue();
            return l < 0L ? new BigDecimal(BigInteger.valueOf(l).and(UnsignedLong.MASK), scale) : BigDecimal.valueOf(l, scale);
        }

        @Override
        public Object asObject() {
            return this.isNullOrEmpty() ? null : UnsignedLong.valueOf(this.getValue());
        }

        @Override
        public String asString() {
            return this.isNullOrEmpty() ? null : Long.toUnsignedString(this.getValue());
        }

        @Override
        public ClickHouseLongValue copy(boolean deep) {
            return new UnsignedLongValue(this.isNullOrEmpty(), this.getValue());
        }

        @Override
        public String toSqlExpression() {
            return this.isNullOrEmpty() ? "NULL" : Long.toUnsignedString(this.getValue());
        }

        @Override
        public ClickHouseLongValue update(byte value) {
            return this.set(false, 0xFFL & (long)value);
        }

        @Override
        public ClickHouseLongValue update(short value) {
            return this.set(false, 0xFFFFL & (long)value);
        }

        @Override
        public ClickHouseLongValue update(int value) {
            return this.set(false, 0xFFFFFFFFL & (long)value);
        }

        @Override
        public ClickHouseLongValue update(BigInteger value) {
            return value == null ? this.resetToNullOrEmpty() : this.set(false, value.longValue());
        }

        @Override
        public ClickHouseLongValue update(BigDecimal value) {
            return value == null ? this.resetToNullOrEmpty() : this.set(false, value.longValue());
        }

        @Override
        public ClickHouseLongValue update(String value) {
            if (value == null) {
                this.resetToNullOrEmpty();
            } else if (value.isEmpty()) {
                this.resetToDefault();
            } else {
                this.set(false, Long.parseUnsignedLong(value));
            }
            return this;
        }
    }
}

