/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.agent.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hertzbeat.ai.agent.config.CustomSseServerTransport;
import org.apache.hertzbeat.ai.agent.service.McpServerService;
import org.apache.hertzbeat.ai.agent.tools.impl.MonitorToolsImpl;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.method.MethodToolCallbackProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.ServerResponse;

@Service
@Configuration
public class McpServerServiceImpl
implements McpServerService {
    @Autowired
    private MonitorToolsImpl monitorTools;

    @Override
    @Bean
    public ToolCallbackProvider hertzbeatTools() {
        return MethodToolCallbackProvider.builder().toolObjects(new Object[]{this.monitorTools}).build();
    }

    @Bean
    public CustomSseServerTransport webMvcSseServerTransportProvider(ObjectMapper objectMapper, McpServerProperties serverProperties) {
        return new CustomSseServerTransport(objectMapper, serverProperties.getBaseUrl(), serverProperties.getSseMessageEndpoint(), serverProperties.getSseEndpoint());
    }

    @Primary
    @Bean
    public RouterFunction<ServerResponse> mvcMcpRouterFunction(CustomSseServerTransport transport) {
        return transport.getRouterFunction();
    }
}

