/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.agent.controller;

import org.apache.hertzbeat.ai.agent.pojo.dto.ChatRequestContext;
import org.apache.hertzbeat.ai.agent.service.ChatClientProviderService;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/chat"})
public class ChatController {
    private final ChatClientProviderService chatClientProviderService;

    @Autowired
    public ChatController(@Qualifier(value="openAiChatClient") ChatClient openAiChatClient, ChatClientProviderService chatClientProviderService) {
        this.chatClientProviderService = chatClientProviderService;
    }

    @PostMapping(value={"/stream"}, produces={"text/event-stream"})
    public SseEmitter streamChat(@RequestBody ChatRequestContext context) {
        SseEmitter emitter = new SseEmitter();
        new Thread(() -> {
            try {
                String aiResponse = this.chatClientProviderService.streamChat(context);
                emitter.send((Object)aiResponse);
                emitter.complete();
            }
            catch (Exception e) {
                emitter.completeWithError((Throwable)e);
            }
        }).start();
        return emitter;
    }
}

