/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.listener;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.hertzbeat.common.support.event.SystemConfigChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class TimeZoneListener {
    private static final Logger log = LoggerFactory.getLogger(TimeZoneListener.class);
    @Resource
    private ObjectMapper objectMapper;

    @EventListener(value={SystemConfigChangeEvent.class})
    public void onEvent(SystemConfigChangeEvent event) {
        log.info("{} receive system config change event: {}.", (Object)this.getClass().getName(), event.getSource());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        this.objectMapper.setTimeZone(TimeZone.getDefault()).setDateFormat((DateFormat)simpleDateFormat);
    }
}

