/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class JobContext
extends HelixProperty {
    private boolean isModified = false;

    public JobContext(ZNRecord record) {
        super(record);
    }

    public void setStartTime(long t) {
        if (this.getStartTime() != t) {
            this._record.setSimpleField(ContextProperties.START_TIME.toString(), String.valueOf(t));
            this.markJobContextAsModified();
        }
    }

    public long getStartTime() {
        String tStr = this._record.getSimpleField(ContextProperties.START_TIME.toString());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setFinishTime(long t) {
        if (this.getFinishTime() != t) {
            this._record.setSimpleField(ContextProperties.FINISH_TIME.toString(), String.valueOf(t));
            this.markJobContextAsModified();
        }
    }

    public long getFinishTime() {
        String tStr = this._record.getSimpleField(ContextProperties.FINISH_TIME.toString());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setInfo(String info) {
        if (info != null && !info.equals(this.getInfo())) {
            this._record.setSimpleField(ContextProperties.INFO.toString(), info);
            this.markJobContextAsModified();
        }
    }

    public String getInfo() {
        return this._record.getSimpleField(ContextProperties.INFO.toString());
    }

    public void setPartitionState(int p, TaskPartitionState s) {
        if (s != null && !s.equals((Object)this.getPartitionState(p))) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.STATE.toString(), s.name());
            this.markJobContextAsModified();
        }
    }

    public TaskPartitionState getPartitionState(int p) {
        Map<String, String> map = this.getMapField(p);
        if (map == null) {
            return null;
        }
        String str = map.get(ContextProperties.STATE.toString());
        if (str != null) {
            return TaskPartitionState.valueOf(str);
        }
        return null;
    }

    public void setPartitionNumAttempts(int p, int n) {
        if (this.getPartitionNumAttempts(p) != n) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.NUM_ATTEMPTS.toString(), String.valueOf(n));
            this.markJobContextAsModified();
        }
    }

    public int incrementNumAttempts(int pId) {
        int n = this.getPartitionNumAttempts(pId);
        if (n < 0) {
            n = 0;
        }
        this.setPartitionNumAttempts(pId, ++n);
        return n;
    }

    public int getPartitionNumAttempts(int p) {
        Map<String, String> map = this.getMapField(p);
        if (map == null) {
            return -1;
        }
        String nStr = map.get(ContextProperties.NUM_ATTEMPTS.toString());
        if (nStr == null) {
            return -1;
        }
        return Integer.parseInt(nStr);
    }

    public void setPartitionStartTime(int p, long t) {
        if (this.getPartitionStartTime(p) != t) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.START_TIME.toString(), String.valueOf(t));
            this.markJobContextAsModified();
        }
    }

    public long getPartitionStartTime(int p) {
        Map<String, String> map = this.getMapField(p);
        if (map == null) {
            return -1L;
        }
        String tStr = map.get(ContextProperties.START_TIME.toString());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setPartitionFinishTime(int p, long t) {
        if (this.getPartitionFinishTime(p) != t) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.FINISH_TIME.toString(), String.valueOf(t));
            this.markJobContextAsModified();
        }
    }

    public long getPartitionFinishTime(int p) {
        Map<String, String> map = this.getMapField(p);
        if (map == null) {
            return -1L;
        }
        String tStr = map.get(ContextProperties.FINISH_TIME.toString());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setPartitionTarget(int p, String targetPName) {
        if (targetPName != null && !targetPName.equals(this.getTargetForPartition(p))) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.TARGET.toString(), targetPName);
            this.markJobContextAsModified();
        }
    }

    public String getTargetForPartition(int p) {
        Map<String, String> map = this.getMapField(p);
        return map != null ? map.get(ContextProperties.TARGET.toString()) : null;
    }

    public void setPartitionInfo(int p, String info) {
        if (info != null && !info.equals(this.getPartitionInfo(p))) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.INFO.toString(), info);
            this.markJobContextAsModified();
        }
    }

    public String getPartitionInfo(int p) {
        Map<String, String> map = this.getMapField(p);
        return map != null ? map.get(ContextProperties.INFO.toString()) : null;
    }

    public Map<String, List<Integer>> getPartitionsByTarget() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Map<String, String>> mapField : this._record.getMapFields().entrySet()) {
            List<Integer> partitions;
            Integer pId = Integer.parseInt(mapField.getKey());
            Map<String, String> map = mapField.getValue();
            String target = map.get(ContextProperties.TARGET.toString());
            if (target == null) continue;
            if (!result.containsKey(target)) {
                partitions = Lists.newArrayList();
                result.put(target, partitions);
            } else {
                partitions = (List)result.get(target);
            }
            partitions.add(pId);
        }
        return result;
    }

    public Set<Integer> getPartitionSet() {
        HashSet partitions = Sets.newHashSet();
        for (String pName : this._record.getMapFields().keySet()) {
            partitions.add(Integer.valueOf(pName));
        }
        return partitions;
    }

    public void setTaskIdForPartition(int p, String taskId) {
        if (taskId != null && !taskId.equals(this.getTaskIdForPartition(p))) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.TASK_ID.toString(), taskId);
            this.markJobContextAsModified();
        }
    }

    public String getTaskIdForPartition(int p) {
        Map<String, String> map = this.getMapField(p);
        return map != null ? map.get(ContextProperties.TASK_ID.toString()) : null;
    }

    public Map<String, Integer> getTaskIdPartitionMap() {
        HashMap<String, Integer> partitionMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Map<String, String>> mapField : this._record.getMapFields().entrySet()) {
            Integer pId = Integer.parseInt(mapField.getKey());
            Map<String, String> map = mapField.getValue();
            if (!map.containsKey(ContextProperties.TASK_ID.toString())) continue;
            partitionMap.put(map.get(ContextProperties.TASK_ID.toString()), pId);
        }
        return partitionMap;
    }

    public void setAssignedParticipant(int p, String participantName) {
        if (participantName != null && !participantName.equals(this.getAssignedParticipant(p))) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.ASSIGNED_PARTICIPANT.toString(), participantName);
            this.markJobContextAsModified();
        }
    }

    public String getAssignedParticipant(int p) {
        Map<String, String> map = this.getMapField(p);
        return map != null ? map.get(ContextProperties.ASSIGNED_PARTICIPANT.toString()) : null;
    }

    public void setNextRetryTime(int p, long t) {
        if (this.getNextRetryTime(p) != t) {
            Map<String, String> map = this.getMapField(p, true);
            map.put(ContextProperties.NEXT_RETRY_TIME.toString(), String.valueOf(t));
            this.markJobContextAsModified();
        }
    }

    public long getNextRetryTime(int p) {
        Map<String, String> map = this.getMapField(p);
        if (map == null) {
            return -1L;
        }
        String tStr = map.get(ContextProperties.NEXT_RETRY_TIME.toString());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this._record.setSimpleField(ContextProperties.NAME.name(), name);
            this.markJobContextAsModified();
        }
    }

    public String getName() {
        return this._record.getSimpleField(ContextProperties.NAME.name());
    }

    public void setExecutionStartTime(long t) {
        if (this.getExecutionStartTime() == -1L) {
            this._record.setSimpleField(ContextProperties.EXECUTION_START_TIME.toString(), String.valueOf(t));
            this.markJobContextAsModified();
        }
    }

    public long getExecutionStartTime() {
        String tStr = this._record.getSimpleField(ContextProperties.EXECUTION_START_TIME.toString());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public Map<String, String> getMapField(int p) {
        return this.getMapField(p, false);
    }

    private Map<String, String> getMapField(int p, boolean createIfNotPresent) {
        String pStr = String.valueOf(p);
        Map<String, String> map = this._record.getMapField(pStr);
        if (map == null && createIfNotPresent) {
            map = new TreeMap<String, String>();
            this._record.setMapField(pStr, map);
        }
        return map;
    }

    public void removePartition(int partitionSeqNumber) {
        if (this.getPartitionSet().contains(partitionSeqNumber)) {
            this._record.getMapFields().remove(String.valueOf(partitionSeqNumber));
            this.markJobContextAsModified();
        }
    }

    public void markJobContextAsModified() {
        this.isModified = true;
    }

    public boolean isJobContextModified() {
        return this.isModified;
    }

    private static enum ContextProperties {
        START_TIME,
        STATE,
        NUM_ATTEMPTS,
        FINISH_TIME,
        TARGET,
        TASK_ID,
        ASSIGNED_PARTICIPANT,
        NEXT_RETRY_TIME,
        INFO,
        NAME,
        EXECUTION_START_TIME;

    }
}

