/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.clusterMaintenanceService;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.helix.PropertyKey;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.rest.clusterMaintenanceService.MaintenanceManagementService;
import org.apache.helix.rest.server.json.cluster.ClusterTopology;
import org.apache.helix.rest.server.json.instance.StoppableCheck;
import org.apache.helix.rest.server.resources.helix.InstancesAccessor;

public class StoppableInstancesSelector {
    private static final String INSTANCE_NOT_EXIST = "HELIX:INSTANCE_NOT_EXIST";
    private final String _clusterId;
    private List<String> _orderOfZone;
    private final String _customizedInput;
    private final MaintenanceManagementService _maintenanceService;
    private final ClusterTopology _clusterTopology;
    private final ZKHelixDataAccessor _dataAccessor;

    private StoppableInstancesSelector(String clusterId, List<String> orderOfZone, String customizedInput, MaintenanceManagementService maintenanceService, ClusterTopology clusterTopology, ZKHelixDataAccessor dataAccessor) {
        this._clusterId = clusterId;
        this._orderOfZone = orderOfZone;
        this._customizedInput = customizedInput;
        this._maintenanceService = maintenanceService;
        this._clusterTopology = clusterTopology;
        this._dataAccessor = dataAccessor;
    }

    public ObjectNode getStoppableInstancesInSingleZone(List<String> instances, List<String> toBeStoppedInstances) throws IOException {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        ArrayNode stoppableInstances = result.putArray(InstancesAccessor.InstancesProperties.instance_stoppable_parallel.name());
        ObjectNode failedStoppableInstances = result.putObject(InstancesAccessor.InstancesProperties.instance_not_stoppable_with_reasons.name());
        HashSet<String> toBeStoppedInstancesSet = new HashSet<String>(toBeStoppedInstances);
        this.collectEvacuatingInstances(toBeStoppedInstancesSet);
        List<String> zoneBasedInstance = this.getZoneBasedInstances(instances, this._clusterTopology.toZoneMapping());
        this.populateStoppableInstances(zoneBasedInstance, toBeStoppedInstancesSet, stoppableInstances, failedStoppableInstances);
        this.processNonexistentInstances(instances, failedStoppableInstances);
        return result;
    }

    public ObjectNode getStoppableInstancesCrossZones(List<String> instances, List<String> toBeStoppedInstances) throws IOException {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        ArrayNode stoppableInstances = result.putArray(InstancesAccessor.InstancesProperties.instance_stoppable_parallel.name());
        ObjectNode failedStoppableInstances = result.putObject(InstancesAccessor.InstancesProperties.instance_not_stoppable_with_reasons.name());
        HashSet<String> toBeStoppedInstancesSet = new HashSet<String>(toBeStoppedInstances);
        this.collectEvacuatingInstances(toBeStoppedInstancesSet);
        Map<String, Set<String>> zoneMapping = this._clusterTopology.toZoneMapping();
        for (String zone : this._orderOfZone) {
            HashSet<String> instanceSet = new HashSet<String>(instances);
            HashSet currentZoneInstanceSet = new HashSet(zoneMapping.get(zone));
            instanceSet.retainAll(currentZoneInstanceSet);
            if (instanceSet.isEmpty()) continue;
            this.populateStoppableInstances(new ArrayList<String>(instanceSet), toBeStoppedInstancesSet, stoppableInstances, failedStoppableInstances);
        }
        this.processNonexistentInstances(instances, failedStoppableInstances);
        return result;
    }

    private void populateStoppableInstances(List<String> instances, Set<String> toBeStoppedInstances, ArrayNode stoppableInstances, ObjectNode failedStoppableInstances) throws IOException {
        Map<String, StoppableCheck> instancesStoppableChecks = this._maintenanceService.batchGetInstancesStoppableChecks(this._clusterId, instances, this._customizedInput, toBeStoppedInstances);
        for (Map.Entry<String, StoppableCheck> instanceStoppableCheck : instancesStoppableChecks.entrySet()) {
            String instance = instanceStoppableCheck.getKey();
            StoppableCheck stoppableCheck = instanceStoppableCheck.getValue();
            if (!stoppableCheck.isStoppable()) {
                ArrayNode failedReasonsNode = failedStoppableInstances.putArray(instance);
                for (String failedReason : stoppableCheck.getFailedChecks()) {
                    failedReasonsNode.add((JsonNode)JsonNodeFactory.instance.textNode(failedReason));
                }
                continue;
            }
            stoppableInstances.add(instance);
            toBeStoppedInstances.add(instance);
        }
    }

    private void processNonexistentInstances(List<String> instances, ObjectNode failedStoppableInstances) {
        HashSet<String> nonSelectedInstances = new HashSet<String>(instances);
        nonSelectedInstances.removeAll(this._clusterTopology.getAllInstances());
        for (String nonSelectedInstance : nonSelectedInstances) {
            ArrayNode failedReasonsNode = failedStoppableInstances.putArray(nonSelectedInstance);
            failedReasonsNode.add((JsonNode)JsonNodeFactory.instance.textNode(INSTANCE_NOT_EXIST));
        }
    }

    public void calculateOrderOfZone(List<String> instances, boolean random) {
        if (this._orderOfZone == null) {
            Map<String, Set<String>> zoneMapping = this._clusterTopology.toZoneMapping();
            HashMap<String, Set<String>> zoneToInstancesMap = new HashMap<String, Set<String>>();
            for (ClusterTopology.Zone zone : this._clusterTopology.getZones()) {
                HashSet<String> instanceSet = new HashSet<String>(instances);
                HashSet currentZoneInstanceSet = new HashSet(zoneMapping.get(zone.getId()));
                instanceSet.retainAll(currentZoneInstanceSet);
                if (instanceSet.isEmpty()) continue;
                zoneToInstancesMap.put(zone.getId(), instanceSet);
            }
            this._orderOfZone = new ArrayList<String>(this.getOrderedZoneToInstancesMap(zoneToInstancesMap).keySet());
        }
        if (this._orderOfZone.isEmpty()) {
            return;
        }
        if (random) {
            Collections.shuffle(this._orderOfZone);
        }
    }

    private List<String> getZoneBasedInstances(List<String> instances, Map<String, Set<String>> zoneMapping) {
        if (this._orderOfZone.isEmpty()) {
            return this._orderOfZone;
        }
        TreeSet<String> instanceSet = null;
        for (String zone : this._orderOfZone) {
            instanceSet = new TreeSet<String>(instances);
            HashSet currentZoneInstanceSet = new HashSet(zoneMapping.get(zone));
            instanceSet.retainAll(currentZoneInstanceSet);
            if (instanceSet.size() <= 0) continue;
            return new ArrayList<String>(instanceSet);
        }
        return Collections.EMPTY_LIST;
    }

    private Map<String, Set<String>> getOrderedZoneToInstancesMap(Map<String, Set<String>> zoneMapping) {
        return zoneMapping.entrySet().stream().sorted((e1, e2) -> ((Set)e2.getValue()).size() - ((Set)e1.getValue()).size()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
    }

    private void collectEvacuatingInstances(Set<String> toBeStoppedInstances) {
        Set<String> allInstances = this._clusterTopology.getAllInstances();
        for (String instance : allInstances) {
            PropertyKey.Builder propertyKeyBuilder = this._dataAccessor.keyBuilder();
            InstanceConfig instanceConfig = (InstanceConfig)this._dataAccessor.getProperty(propertyKeyBuilder.instanceConfig(instance));
            if (!InstanceConstants.InstanceOperation.EVACUATE.equals((Object)instanceConfig.getInstanceOperation().getOperation())) continue;
            toBeStoppedInstances.add(instance);
        }
    }

    public static class StoppableInstancesSelectorBuilder {
        private String _clusterId;
        private List<String> _orderOfZone;
        private String _customizedInput;
        private MaintenanceManagementService _maintenanceService;
        private ClusterTopology _clusterTopology;
        private ZKHelixDataAccessor _dataAccessor;

        public StoppableInstancesSelectorBuilder setClusterId(String clusterId) {
            this._clusterId = clusterId;
            return this;
        }

        public StoppableInstancesSelectorBuilder setOrderOfZone(List<String> orderOfZone) {
            this._orderOfZone = orderOfZone;
            return this;
        }

        public StoppableInstancesSelectorBuilder setCustomizedInput(String customizedInput) {
            this._customizedInput = customizedInput;
            return this;
        }

        public StoppableInstancesSelectorBuilder setMaintenanceService(MaintenanceManagementService maintenanceService) {
            this._maintenanceService = maintenanceService;
            return this;
        }

        public StoppableInstancesSelectorBuilder setClusterTopology(ClusterTopology clusterTopology) {
            this._clusterTopology = clusterTopology;
            return this;
        }

        public StoppableInstancesSelectorBuilder setDataAccessor(ZKHelixDataAccessor dataAccessor) {
            this._dataAccessor = dataAccessor;
            return this;
        }

        public StoppableInstancesSelector build() {
            return new StoppableInstancesSelector(this._clusterId, this._orderOfZone, this._customizedInput, this._maintenanceService, this._clusterTopology, this._dataAccessor);
        }
    }
}

