/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.topology;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.cloud.topology.VirtualGroupAssignmentAlgorithm;
import org.apache.helix.util.HelixUtil;

public class FifoVirtualGroupAssignmentAlgorithm
implements VirtualGroupAssignmentAlgorithm {
    private static final FifoVirtualGroupAssignmentAlgorithm _instance = new FifoVirtualGroupAssignmentAlgorithm();

    private FifoVirtualGroupAssignmentAlgorithm() {
    }

    public static FifoVirtualGroupAssignmentAlgorithm getInstance() {
        return _instance;
    }

    @Override
    public Map<String, Set<String>> computeAssignment(int numGroups, String virtualGroupName, Map<String, Set<String>> zoneMapping) {
        List<String> sortedInstances = HelixUtil.sortAndFlattenZoneMapping(zoneMapping);
        HashMap assignment = new HashMap();
        int instancesPerGroupBase = sortedInstances.size() / numGroups;
        int residuals = sortedInstances.size() % numGroups;
        ArrayList<Integer> numInstances = new ArrayList<Integer>();
        int instanceInd = 0;
        for (int groupInd = 0; groupInd < numGroups; ++groupInd) {
            int num = groupInd < residuals ? instancesPerGroupBase + 1 : instancesPerGroupBase;
            String groupId = FifoVirtualGroupAssignmentAlgorithm.computeVirtualGroupId(groupInd, virtualGroupName);
            assignment.put(groupId, new HashSet());
            for (int i = 0; i < num; ++i) {
                ((Set)assignment.get(groupId)).add(sortedInstances.get(instanceInd));
                ++instanceInd;
            }
            numInstances.add(num);
        }
        Preconditions.checkState((numInstances.stream().mapToInt(Integer::intValue).sum() == sortedInstances.size() ? 1 : 0) != 0);
        return ImmutableMap.copyOf(assignment);
    }

    private static String computeVirtualGroupId(int groupIndex, String virtualGroupName) {
        return virtualGroupName + "_" + groupIndex;
    }
}

