/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixCloudProperty;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.LiveInstanceInfoProvider;
import org.apache.helix.PreConnectCallback;
import org.apache.helix.PropertyKey;
import org.apache.helix.api.cloud.CloudInstanceInformation;
import org.apache.helix.api.cloud.CloudInstanceInformationProcessor;
import org.apache.helix.api.cloud.CloudInstanceInformationV2;
import org.apache.helix.manager.zk.CurStateCarryOverUpdater;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.messaging.DefaultMessagingService;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.ParticipantHistory;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.ScheduledTaskStateModelFactory;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.ZNRecordBucketizer;
import org.apache.helix.zookeeper.exception.ZkClientException;
import org.apache.helix.zookeeper.zkclient.exception.ZkNodeExistsException;
import org.apache.helix.zookeeper.zkclient.exception.ZkSessionMismatchedException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantManager {
    private static Logger LOG = LoggerFactory.getLogger(ParticipantManager.class);
    final RealmAwareZkClient _zkclient;
    final HelixManager _manager;
    final PropertyKey.Builder _keyBuilder;
    final String _clusterName;
    final String _instanceName;
    final int _sessionTimeout;
    final ConfigAccessor _configAccessor;
    final InstanceType _instanceType;
    final HelixAdmin _helixAdmin;
    final ZKHelixDataAccessor _dataAccessor;
    final DefaultMessagingService _messagingService;
    final StateMachineEngine _stateMachineEngine;
    final LiveInstanceInfoProvider _liveInstanceInfoProvider;
    final List<PreConnectCallback> _preConnectCallbacks;
    final HelixManagerProperty _helixManagerProperty;
    private final String _sessionId;

    @Deprecated
    public ParticipantManager(HelixManager manager, RealmAwareZkClient zkclient, int sessionTimeout, LiveInstanceInfoProvider liveInstanceInfoProvider, List<PreConnectCallback> preConnectCallbacks, String sessionId) {
        this(manager, zkclient, sessionTimeout, liveInstanceInfoProvider, preConnectCallbacks, sessionId, null);
    }

    public ParticipantManager(HelixManager manager, RealmAwareZkClient zkclient, int sessionTimeout, LiveInstanceInfoProvider liveInstanceInfoProvider, List<PreConnectCallback> preConnectCallbacks, String sessionId, HelixManagerProperty helixManagerProperty) {
        this._zkclient = zkclient;
        this._manager = manager;
        this._clusterName = manager.getClusterName();
        this._instanceName = manager.getInstanceName();
        this._keyBuilder = new PropertyKey.Builder(this._clusterName);
        this._sessionId = sessionId;
        this._sessionTimeout = sessionTimeout;
        this._configAccessor = manager.getConfigAccessor();
        this._instanceType = manager.getInstanceType();
        this._helixAdmin = manager.getClusterManagmentTool();
        this._dataAccessor = (ZKHelixDataAccessor)manager.getHelixDataAccessor();
        this._messagingService = (DefaultMessagingService)manager.getMessagingService();
        this._stateMachineEngine = manager.getStateMachineEngine();
        this._liveInstanceInfoProvider = liveInstanceInfoProvider;
        this._preConnectCallbacks = preConnectCallbacks;
        this._helixManagerProperty = helixManagerProperty;
    }

    public void handleNewSession() throws Exception {
        String zkClientHexSession = ZKUtil.toHexSessionId(this._zkclient.getSessionId());
        if (!zkClientHexSession.equals(this._sessionId)) {
            throw new HelixException("Failed to handle new session for participant. There is a session mismatch: participant manager session = " + this._sessionId + ", zk client session = " + zkClientHexSession);
        }
        this.joinCluster();
        for (PreConnectCallback callback : this._preConnectCallbacks) {
            callback.onPreConnect();
        }
        if (this.shouldCarryOver()) {
            ParticipantManager.carryOverPreviousCurrentState(this._dataAccessor, this._instanceName, this._sessionId, this._manager.getStateMachineEngine(), true);
        }
        this.createLiveInstance();
        this.removePreviousTaskCurrentStates();
        this.setupMsgHandler();
    }

    private boolean shouldCarryOver() {
        if (this._liveInstanceInfoProvider == null || this._liveInstanceInfoProvider.getAdditionalLiveInstanceInfo() == null) {
            return true;
        }
        String status = this._liveInstanceInfoProvider.getAdditionalLiveInstanceInfo().getSimpleField(LiveInstance.LiveInstanceProperty.STATUS.name());
        return !LiveInstance.LiveInstanceStatus.FROZEN.name().equals(status);
    }

    private void joinCluster() {
        boolean autoJoin = false;
        boolean autoRegistration = false;
        try {
            HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(this._manager.getClusterName()).build();
            autoJoin = Boolean.parseBoolean(this._configAccessor.get(scope, "allowParticipantAutoJoin"));
            LOG.info("instance: " + this._instanceName + " auto-joining " + this._clusterName + " is " + autoJoin);
        }
        catch (Exception e) {
            LOG.info("auto join is false for cluster" + this._clusterName);
        }
        try {
            autoRegistration = this._helixManagerProperty.getHelixCloudProperty().getCloudEnabled();
            LOG.info("instance: " + this._instanceName + " auto-registering " + this._clusterName + " is " + autoRegistration);
        }
        catch (Exception e) {
            LOG.info("auto registration is false for cluster" + this._clusterName);
        }
        if (!ZKUtil.isInstanceSetup(this._zkclient, this._clusterName, this._instanceName, this._instanceType)) {
            InstanceConfig instanceConfig;
            if (!autoJoin) {
                throw new HelixException("Initial cluster structure is not set up for instance: " + this._instanceName + ", instanceType: " + this._instanceType);
            }
            InstanceConfig.Builder instanceConfigBuilder = this._helixManagerProperty.getDefaultInstanceConfigBuilder();
            if (!autoRegistration) {
                LOG.info(this._instanceName + " is auto-joining cluster: " + this._clusterName);
                instanceConfig = instanceConfigBuilder.build(this._instanceName);
            } else {
                String cloudInstanceInformationFaultDomain;
                LOG.info(this._instanceName + " is auto-registering cluster: " + this._clusterName);
                CloudInstanceInformation cloudInstanceInformation = this.getCloudInstanceInformation();
                if (cloudInstanceInformation instanceof CloudInstanceInformationV2) {
                    CloudInstanceInformationV2 cloudInstanceInformationV2 = (CloudInstanceInformationV2)cloudInstanceInformation;
                    cloudInstanceInformationV2.getAll().forEach(instanceConfigBuilder::addInstanceInfo);
                }
                instanceConfig = instanceConfigBuilder.setDomain((String)((cloudInstanceInformationFaultDomain = cloudInstanceInformation.get(CloudInstanceInformation.CloudInstanceField.FAULT_DOMAIN.name())).endsWith("=") ? cloudInstanceInformationFaultDomain + this._instanceName : cloudInstanceInformationFaultDomain)).build(this._instanceName);
            }
            instanceConfig.validateTopologySettingInInstanceConfig(this._configAccessor.getClusterConfig(this._clusterName), this._instanceName);
            this._helixAdmin.addInstance(this._clusterName, instanceConfig);
        } else {
            this._configAccessor.getInstanceConfig(this._clusterName, this._instanceName).validateTopologySettingInInstanceConfig(this._configAccessor.getClusterConfig(this._clusterName), this._instanceName);
        }
    }

    private CloudInstanceInformation getCloudInstanceInformation() {
        try {
            Class<?> processorClass = Class.forName(this._helixManagerProperty.getHelixCloudProperty().getCloudInfoProcessorFullyQualifiedClassName());
            Constructor<?> constructor = processorClass.getConstructor(HelixCloudProperty.class);
            CloudInstanceInformationProcessor processor = (CloudInstanceInformationProcessor)constructor.newInstance(this._helixManagerProperty.getHelixCloudProperty());
            List responses = processor.fetchCloudInstanceInformation();
            CloudInstanceInformation cloudInstanceInformation = processor.parseCloudInstanceInformation(responses);
            return cloudInstanceInformation;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new HelixException("Failed to create a new instance for the class: " + this._helixManagerProperty.getHelixCloudProperty().getCloudInfoProcessorFullyQualifiedClassName(), ex);
        }
    }

    private void createLiveInstance() {
        boolean retry;
        String liveInstancePath = this._keyBuilder.liveInstance(this._instanceName).getPath();
        LiveInstance liveInstance = new LiveInstance(this._instanceName);
        liveInstance.setSessionId(this._sessionId);
        liveInstance.setHelixVersion(this._manager.getVersion());
        liveInstance.setLiveInstance(ManagementFactory.getRuntimeMXBean().getName());
        liveInstance.setCurrentTaskThreadPoolSize(TaskUtil.getTargetThreadPoolSize(this._zkclient, this._clusterName, this._instanceName));
        if (this._liveInstanceInfoProvider != null) {
            LOG.info("invoke liveInstanceInfoProvider");
            ZNRecord additionalLiveInstanceInfo = this._liveInstanceInfoProvider.getAdditionalLiveInstanceInfo();
            if (additionalLiveInstanceInfo != null) {
                additionalLiveInstanceInfo.merge(liveInstance.getRecord());
                ZNRecord mergedLiveInstance = new ZNRecord(additionalLiveInstanceInfo, this._instanceName);
                liveInstance = new LiveInstance(mergedLiveInstance);
                LOG.info("instanceName: " + this._instanceName + ", mergedLiveInstance: " + liveInstance);
            }
        }
        do {
            retry = false;
            try {
                this._zkclient.createEphemeral(liveInstancePath, (Object)liveInstance.getRecord(), this._sessionId);
                LOG.info("LiveInstance created, path: {}, sessionId: {}", (Object)liveInstancePath, (Object)liveInstance.getEphemeralOwner());
            }
            catch (ZkSessionMismatchedException e) {
                throw new HelixException("Failed to create live instance, path: " + liveInstancePath + ". Caused by: " + e.getMessage());
            }
            catch (ZkNodeExistsException e) {
                LOG.warn("Found another instance with same instance name: {} in cluster: {}", (Object)this._instanceName, (Object)this._clusterName);
                Stat stat = new Stat();
                ZNRecord record = (ZNRecord)this._zkclient.readData(liveInstancePath, stat, true);
                if (record == null) {
                    retry = true;
                    continue;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(this._sessionTimeout + 5000);
                }
                catch (InterruptedException ex) {
                    LOG.warn("Sleep interrupted while waiting for previous live-instance to go away.", (Throwable)ex);
                }
                retry = true;
                break;
            }
        } while (retry);
        if (retry) {
            try {
                this._zkclient.createEphemeral(liveInstancePath, (Object)liveInstance.getRecord(), this._sessionId);
                LOG.info("LiveInstance created, path: {}, sessionId: {}", (Object)liveInstancePath, (Object)liveInstance.getEphemeralOwner());
            }
            catch (ZkSessionMismatchedException e) {
                throw new HelixException("Failed to create live instance, path: " + liveInstancePath + ". Caused by: " + e.getMessage());
            }
            catch (ZkNodeExistsException e) {
                throw new HelixException("Failed to create live instance because instance: " + this._instanceName + " already has a live-instance in cluster: " + this._clusterName + ". Path is: " + liveInstancePath);
            }
            catch (Exception e) {
                throw new HelixException("Failed to create live instance. " + e.getMessage());
            }
        }
        ParticipantHistory history = this.getHistory();
        history.reportOnline(this._sessionId, this._manager.getVersion());
        this.persistHistory(history, false);
    }

    public static synchronized void carryOverPreviousCurrentState(HelixDataAccessor dataAccessor, String instanceName, String sessionId, StateMachineEngine stateMachineEngine, boolean setToInitState) {
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        List<String> sessions = dataAccessor.getChildNames(keyBuilder.sessions(instanceName));
        for (String session : sessions) {
            if (session.equals(sessionId)) continue;
            List lastCurStates = dataAccessor.getChildValues(keyBuilder.currentStates(instanceName, session), false);
            for (CurrentState lastCurState : lastCurStates) {
                LOG.info("Carrying over old session: " + session + ", resource: " + lastCurState.getId() + " to current session: " + sessionId + ", setToInitState: " + setToInitState);
                String stateModelDefRef = lastCurState.getStateModelDefRef();
                if (stateModelDefRef == null) {
                    LOG.error("skip carry-over because previous current state doesn't have a state model definition. previous current-state: " + lastCurState);
                    continue;
                }
                if (stateModelDefRef.equals("Task")) continue;
                StateModelDefinition stateModelDef = (StateModelDefinition)dataAccessor.getProperty(keyBuilder.stateModelDef(stateModelDefRef));
                String initState = stateModelDef.getInitialState();
                HashMap<String, String> partitionExpectedStateMap = new HashMap<String, String>();
                if (setToInitState) {
                    lastCurState.getPartitionStateMap().keySet().forEach(partition -> partitionExpectedStateMap.put((String)partition, initState));
                } else {
                    String factoryName = lastCurState.getStateModelFactoryName();
                    StateModelFactory<? extends StateModel> stateModelFactory = stateMachineEngine.getStateModelFactory(stateModelDefRef, factoryName);
                    lastCurState.getPartitionStateMap().keySet().forEach(partition -> {
                        Object stateModel = stateModelFactory.getStateModel(lastCurState.getResourceName(), (String)partition);
                        if (stateModel != null) {
                            partitionExpectedStateMap.put((String)partition, ((StateModel)stateModel).getCurrentState());
                        }
                    });
                }
                BaseDataAccessor<ZNRecord> baseAccessor = dataAccessor.getBaseDataAccessor();
                String curStatePath = keyBuilder.currentState(instanceName, sessionId, lastCurState.getResourceName()).getPath();
                if (lastCurState.getBucketSize() > 0) {
                    ZNRecord metaRecord = new ZNRecord(lastCurState.getId());
                    metaRecord.setSimpleFields(lastCurState.getRecord().getSimpleFields());
                    CurStateCarryOverUpdater metaRecordUpdater = new CurStateCarryOverUpdater(sessionId, partitionExpectedStateMap, new CurrentState(metaRecord));
                    boolean success = baseAccessor.update(curStatePath, metaRecordUpdater, AccessOption.PERSISTENT);
                    if (!success) continue;
                    ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(lastCurState.getBucketSize());
                    Map<String, ZNRecord> map = bucketizer.bucketize(lastCurState.getRecord());
                    ArrayList<String> paths = new ArrayList<String>();
                    ArrayList updaters = new ArrayList();
                    for (String bucketName : map.keySet()) {
                        paths.add(curStatePath + "/" + bucketName);
                        updaters.add(new CurStateCarryOverUpdater(sessionId, partitionExpectedStateMap, new CurrentState(map.get(bucketName))));
                    }
                    baseAccessor.updateChildren(paths, updaters, AccessOption.PERSISTENT);
                    continue;
                }
                dataAccessor.getBaseDataAccessor().update(curStatePath, new CurStateCarryOverUpdater(sessionId, partitionExpectedStateMap, lastCurState), AccessOption.PERSISTENT);
            }
        }
        for (String session : sessions) {
            if (session.equals(sessionId)) continue;
            PropertyKey currentStatesProperty = keyBuilder.currentStates(instanceName, session);
            String path = currentStatesProperty.getPath();
            LOG.info("Removing current states from previous sessions. path: {}", (Object)path);
            if (dataAccessor.removeProperty(currentStatesProperty)) continue;
            throw new ZkClientException("Failed to delete " + path);
        }
    }

    private void removePreviousTaskCurrentStates() {
        for (String session : this._dataAccessor.getChildNames(this._keyBuilder.taskCurrentStateSessions(this._instanceName))) {
            if (session.equals(this._sessionId)) continue;
            String path = this._keyBuilder.taskCurrentStates(this._instanceName, session).getPath();
            LOG.info("Removing task current states from previous sessions. path: " + path);
            this._zkclient.deleteRecursively(path);
        }
    }

    private void setupMsgHandler() throws Exception {
        this._messagingService.registerMessageHandlerFactory(this._stateMachineEngine.getMessageTypes(), (MessageHandlerFactory)this._stateMachineEngine);
        this._manager.addMessageListener(this._messagingService.getExecutor(), this._instanceName);
        ScheduledTaskStateModelFactory stStateModelFactory = new ScheduledTaskStateModelFactory(this._messagingService.getExecutor());
        this._stateMachineEngine.registerStateModelFactory("SchedulerTaskQueue", stStateModelFactory);
        this._messagingService.onConnected();
    }

    private ParticipantHistory getHistory() {
        PropertyKey propertyKey = this._keyBuilder.participantHistory(this._instanceName);
        ParticipantHistory history = (ParticipantHistory)this._dataAccessor.getProperty(propertyKey);
        return history == null ? new ParticipantHistory(this._instanceName) : history;
    }

    private void persistHistory(ParticipantHistory history, boolean skipOnEmptyPath) {
        boolean result;
        PropertyKey propertyKey = this._keyBuilder.participantHistory(this._instanceName);
        boolean bl = result = skipOnEmptyPath ? this._dataAccessor.updateProperty(propertyKey, currentData -> currentData == null ? null : history.getRecord(), history) : this._dataAccessor.setProperty(propertyKey, history);
        if (!result) {
            LOG.error("Failed to persist participant history to zk!");
        }
    }

    public void reset() {
    }

    public void disconnect() {
        try {
            ParticipantHistory history = this.getHistory();
            history.reportOffline();
            this.persistHistory(history, true);
        }
        catch (Exception e) {
            LOG.error("Failed to report participant offline.", (Throwable)e);
        }
        this.reset();
    }
}

