/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeMaxPartitionLimitConstraint
extends HardConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(NodeMaxPartitionLimitConstraint.class);

    NodeMaxPartitionLimitConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        boolean exceedResourceMaxPartitionLimit;
        boolean exceedMaxPartitionLimit;
        boolean bl = exceedMaxPartitionLimit = node.getMaxPartition() < 0 || node.getAssignedReplicaCount() < node.getMaxPartition();
        if (!exceedMaxPartitionLimit) {
            LOG.debug("Cannot exceed the max number of partitions ({}) limitation on node. Assigned replica count: {}", (Object)node.getMaxPartition(), (Object)node.getAssignedReplicaCount());
            return false;
        }
        int resourceMaxPartitionsPerInstance = replica.getResourceMaxPartitionsPerInstance();
        int assignedPartitionsByResourceSize = node.getAssignedPartitionsByResource(replica.getResourceName()).size();
        boolean bl2 = exceedResourceMaxPartitionLimit = resourceMaxPartitionsPerInstance < 0 || assignedPartitionsByResourceSize < resourceMaxPartitionsPerInstance;
        if (!exceedResourceMaxPartitionLimit) {
            if (this.enableLogging) {
                LOG.info("Cannot exceed the max number of partitions per resource ({}) limitation on node. Assigned replica count: {}", (Object)resourceMaxPartitionsPerInstance, (Object)assignedPartitionsByResourceSize);
            }
            return false;
        }
        return true;
    }

    @Override
    String getDescription() {
        return "Cannot exceed the maximum number of partitions limitation on node";
    }
}

