/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.util.Comparator;
import java.util.UUID;
import jdbm.RecordManager;
import jdbm.helper.Serializer;
import jdbm.helper.StringComparator;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.EntrySerializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.StringSerializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.UuidSerializer;
import org.apache.directory.server.xdbm.MasterTable;

public class JdbmMasterTable
extends JdbmTable<String, Entry>
implements MasterTable {
    private static final StringComparator STRCOMP = new StringComparator();
    private static final SerializableComparator<String> STRING_COMPARATOR = new SerializableComparator<String>("1.3.6.1.4.1.18060.0.4.1.1.3"){
        private static final long serialVersionUID = 3258689922792961845L;

        public int compare(String o1, String o2) {
            return STRCOMP.compare(o1, o2);
        }
    };
    protected final JdbmTable<String, String> adminTbl;

    public JdbmMasterTable(RecordManager recMan, SchemaManager schemaManager) throws Exception {
        super(schemaManager, "master", recMan, UuidComparator.INSTANCE, UuidSerializer.INSTANCE, new EntrySerializer(schemaManager));
        this.adminTbl = new JdbmTable(schemaManager, "admin", recMan, (Comparator<String>)STRING_COMPARATOR, StringSerializer.INSTANCE, StringSerializer.INSTANCE);
        String seqValue = this.adminTbl.get("__sequence__");
        if (null == seqValue) {
            this.adminTbl.put("__sequence__", "0");
        }
        UuidComparator.INSTANCE.setSchemaManager(schemaManager);
        STRING_COMPARATOR.setSchemaManager(schemaManager);
    }

    protected JdbmMasterTable(RecordManager recMan, SchemaManager schemaManager, String dbName, Serializer serializer) throws Exception {
        super(schemaManager, "master", recMan, UuidComparator.INSTANCE, UuidSerializer.INSTANCE, serializer);
        this.adminTbl = new JdbmTable(schemaManager, dbName, recMan, (Comparator<String>)STRING_COMPARATOR, StringSerializer.INSTANCE, StringSerializer.INSTANCE);
        String seqValue = this.adminTbl.get("__sequence__");
        if (null == seqValue) {
            this.adminTbl.put("__sequence__", "0");
        }
    }

    public String getNextId(Entry entry) throws Exception {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCounter() throws Exception {
        JdbmTable<String, String> jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            this.adminTbl.put("__sequence__", "0");
        }
    }
}

