/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.metrics.ServerSideScanMetrics;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class ScannerContext {
    LimitFields limits = new LimitFields();
    ProgressFields progress;
    NextState scannerState;
    private static final NextState DEFAULT_STATE = NextState.MORE_VALUES;
    boolean keepProgress;
    private static boolean DEFAULT_KEEP_PROGRESS = false;
    private Cell lastPeekedCell = null;
    private boolean returnImmediately;
    final ServerSideScanMetrics metrics;

    ScannerContext(boolean keepProgress, LimitFields limitsToCopy, boolean trackMetrics) {
        this(keepProgress, limitsToCopy, trackMetrics, null);
    }

    ScannerContext(boolean keepProgress, LimitFields limitsToCopy, boolean trackMetrics, ServerSideScanMetrics scanMetrics) {
        if (limitsToCopy != null) {
            this.limits.copy(limitsToCopy);
        }
        this.progress = new ProgressFields(0, 0L, 0L);
        this.keepProgress = keepProgress;
        this.scannerState = DEFAULT_STATE;
        this.metrics = trackMetrics ? (scanMetrics != null ? scanMetrics : new ServerSideScanMetrics()) : null;
    }

    public boolean isTrackingMetrics() {
        return this.metrics != null;
    }

    public ServerSideScanMetrics getMetrics() {
        assert (this.isTrackingMetrics());
        return this.metrics;
    }

    boolean getKeepProgress() {
        return this.keepProgress;
    }

    void setKeepProgress(boolean keepProgress) {
        this.keepProgress = keepProgress;
    }

    void incrementBatchProgress(int batch) {
        int currentBatch = this.progress.getBatch();
        this.progress.setBatch(currentBatch + batch);
    }

    void incrementSizeProgress(long dataSize, long heapSize) {
        long curDataSize = this.progress.getDataSize();
        this.progress.setDataSize(curDataSize + dataSize);
        long curHeapSize = this.progress.getHeapSize();
        this.progress.setHeapSize(curHeapSize + heapSize);
    }

    @Deprecated
    void updateTimeProgress() {
    }

    int getBatchProgress() {
        return this.progress.getBatch();
    }

    long getDataSizeProgress() {
        return this.progress.getDataSize();
    }

    long getHeapSizeProgress() {
        return this.progress.getHeapSize();
    }

    @Deprecated
    long getTimeProgress() {
        return EnvironmentEdgeManager.currentTime();
    }

    @Deprecated
    void setProgress(int batchProgress, long sizeProgress, long heapSizeProgress, long timeProgress) {
        this.setProgress(batchProgress, sizeProgress, heapSizeProgress);
    }

    void setProgress(int batchProgress, long sizeProgress, long heapSizeProgress) {
        this.setBatchProgress(batchProgress);
        this.setSizeProgress(sizeProgress, heapSizeProgress);
    }

    void setSizeProgress(long dataSizeProgress, long heapSizeProgress) {
        this.progress.setDataSize(dataSizeProgress);
        this.progress.setHeapSize(heapSizeProgress);
    }

    void setBatchProgress(int batchProgress) {
        this.progress.setBatch(batchProgress);
    }

    @Deprecated
    void setTimeProgress(long timeProgress) {
    }

    void clearProgress() {
        this.progress.setFields(0, 0L, 0L);
    }

    NextState setScannerState(NextState state) {
        if (!NextState.isValidState(state)) {
            throw new IllegalArgumentException("Cannot set to invalid state: " + (Object)((Object)state));
        }
        this.scannerState = state;
        return state;
    }

    boolean mayHaveMoreCellsInRow() {
        return this.scannerState == NextState.SIZE_LIMIT_REACHED_MID_ROW || this.scannerState == NextState.TIME_LIMIT_REACHED_MID_ROW || this.scannerState == NextState.BATCH_LIMIT_REACHED;
    }

    boolean hasBatchLimit(LimitScope checkerScope) {
        return this.limits.canEnforceBatchLimitFromScope(checkerScope) && this.limits.getBatch() > 0;
    }

    boolean hasSizeLimit(LimitScope checkerScope) {
        return this.limits.canEnforceSizeLimitFromScope(checkerScope) && (this.limits.getDataSize() > 0L || this.limits.getHeapSize() > 0L);
    }

    boolean hasTimeLimit(LimitScope checkerScope) {
        return this.limits.canEnforceTimeLimitFromScope(checkerScope) && (this.limits.getTime() > 0L || this.returnImmediately);
    }

    boolean hasAnyLimit(LimitScope checkerScope) {
        return this.hasBatchLimit(checkerScope) || this.hasSizeLimit(checkerScope) || this.hasTimeLimit(checkerScope);
    }

    void setSizeLimitScope(LimitScope scope) {
        this.limits.setSizeScope(scope);
    }

    void setTimeLimitScope(LimitScope scope) {
        this.limits.setTimeScope(scope);
    }

    int getBatchLimit() {
        return this.limits.getBatch();
    }

    long getDataSizeLimit() {
        return this.limits.getDataSize();
    }

    long getTimeLimit() {
        return this.limits.getTime();
    }

    boolean checkBatchLimit(LimitScope checkerScope) {
        return this.hasBatchLimit(checkerScope) && this.progress.getBatch() >= this.limits.getBatch();
    }

    boolean checkSizeLimit(LimitScope checkerScope) {
        return this.hasSizeLimit(checkerScope) && (this.progress.getDataSize() >= this.limits.getDataSize() || this.progress.getHeapSize() >= this.limits.getHeapSize());
    }

    boolean checkTimeLimit(LimitScope checkerScope) {
        return this.hasTimeLimit(checkerScope) && (this.returnImmediately || EnvironmentEdgeManager.currentTime() >= this.limits.getTime());
    }

    boolean checkAnyLimitReached(LimitScope checkerScope) {
        return this.checkSizeLimit(checkerScope) || this.checkBatchLimit(checkerScope) || this.checkTimeLimit(checkerScope);
    }

    Cell getLastPeekedCell() {
        return this.lastPeekedCell;
    }

    void setLastPeekedCell(Cell lastPeekedCell) {
        this.lastPeekedCell = lastPeekedCell;
    }

    void returnImmediately() {
        this.returnImmediately = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("limits:");
        sb.append(this.limits);
        sb.append(", progress:");
        sb.append(this.progress);
        sb.append(", keepProgress:");
        sb.append(this.keepProgress);
        sb.append(", state:");
        sb.append((Object)this.scannerState);
        sb.append("}");
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(boolean keepProgress) {
        return new Builder(keepProgress);
    }

    static /* synthetic */ boolean access$200() {
        return DEFAULT_KEEP_PROGRESS;
    }

    private static class ProgressFields {
        private static int DEFAULT_BATCH = -1;
        private static long DEFAULT_SIZE = -1L;
        int batch = DEFAULT_BATCH;
        long dataSize = DEFAULT_SIZE;
        long heapSize = DEFAULT_SIZE;

        ProgressFields(int batch, long size, long heapSize) {
            this.setFields(batch, size, heapSize);
        }

        void setFields(int batch, long dataSize, long heapSize) {
            this.setBatch(batch);
            this.setDataSize(dataSize);
            this.setHeapSize(heapSize);
        }

        int getBatch() {
            return this.batch;
        }

        void setBatch(int batch) {
            this.batch = batch;
        }

        long getDataSize() {
            return this.dataSize;
        }

        long getHeapSize() {
            return this.heapSize;
        }

        void setDataSize(long dataSize) {
            this.dataSize = dataSize;
        }

        void setHeapSize(long heapSize) {
            this.heapSize = heapSize;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("batch:");
            sb.append(this.batch);
            sb.append(", dataSize:");
            sb.append(this.dataSize);
            sb.append(", heapSize:");
            sb.append(this.heapSize);
            sb.append("}");
            return sb.toString();
        }
    }

    private static class LimitFields {
        private static int DEFAULT_BATCH = -1;
        private static long DEFAULT_SIZE = -1L;
        private static long DEFAULT_TIME = -1L;
        private static final LimitScope DEFAULT_SCOPE = LimitScope.BETWEEN_ROWS;
        int batch = DEFAULT_BATCH;
        LimitScope sizeScope = DEFAULT_SCOPE;
        long dataSize = DEFAULT_SIZE;
        long heapSize = DEFAULT_SIZE;
        LimitScope timeScope = DEFAULT_SCOPE;
        long time = DEFAULT_TIME;

        LimitFields() {
        }

        void copy(LimitFields limitsToCopy) {
            if (limitsToCopy != null) {
                this.setFields(limitsToCopy.getBatch(), limitsToCopy.getSizeScope(), limitsToCopy.getDataSize(), limitsToCopy.getHeapSize(), limitsToCopy.getTimeScope(), limitsToCopy.getTime());
            }
        }

        void setFields(int batch, LimitScope sizeScope, long dataSize, long heapSize, LimitScope timeScope, long time) {
            this.setBatch(batch);
            this.setSizeScope(sizeScope);
            this.setDataSize(dataSize);
            this.setHeapSize(heapSize);
            this.setTimeScope(timeScope);
            this.setTime(time);
        }

        int getBatch() {
            return this.batch;
        }

        void setBatch(int batch) {
            this.batch = batch;
        }

        boolean canEnforceBatchLimitFromScope(LimitScope checkerScope) {
            return LimitScope.BETWEEN_CELLS.canEnforceLimitFromScope(checkerScope);
        }

        long getDataSize() {
            return this.dataSize;
        }

        long getHeapSize() {
            return this.heapSize;
        }

        void setDataSize(long dataSize) {
            this.dataSize = dataSize;
        }

        void setHeapSize(long heapSize) {
            this.heapSize = heapSize;
        }

        LimitScope getSizeScope() {
            return this.sizeScope;
        }

        void setSizeScope(LimitScope scope) {
            this.sizeScope = scope;
        }

        boolean canEnforceSizeLimitFromScope(LimitScope checkerScope) {
            return this.sizeScope.canEnforceLimitFromScope(checkerScope);
        }

        long getTime() {
            return this.time;
        }

        void setTime(long time) {
            this.time = time;
        }

        LimitScope getTimeScope() {
            return this.timeScope;
        }

        void setTimeScope(LimitScope scope) {
            this.timeScope = scope;
        }

        boolean canEnforceTimeLimitFromScope(LimitScope checkerScope) {
            return this.timeScope.canEnforceLimitFromScope(checkerScope);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("batch:");
            sb.append(this.batch);
            sb.append(", dataSize:");
            sb.append(this.dataSize);
            sb.append(", heapSize:");
            sb.append(this.heapSize);
            sb.append(", sizeScope:");
            sb.append((Object)this.sizeScope);
            sb.append(", time:");
            sb.append(this.time);
            sb.append(", timeScope:");
            sb.append((Object)this.timeScope);
            sb.append("}");
            return sb.toString();
        }
    }

    public static enum LimitScope {
        BETWEEN_ROWS(0),
        BETWEEN_CELLS(1);

        final int depth;

        private LimitScope(int depth) {
            this.depth = depth;
        }

        final int depth() {
            return this.depth;
        }

        boolean canEnforceLimitFromScope(LimitScope checkerScope) {
            return checkerScope != null && checkerScope.depth() <= this.depth;
        }
    }

    public static enum NextState {
        MORE_VALUES(true, false),
        NO_MORE_VALUES(false, false),
        SIZE_LIMIT_REACHED(true, true),
        SIZE_LIMIT_REACHED_MID_ROW(true, true),
        TIME_LIMIT_REACHED(true, true),
        TIME_LIMIT_REACHED_MID_ROW(true, true),
        BATCH_LIMIT_REACHED(true, true);

        private final boolean moreValues;
        private final boolean limitReached;

        private NextState(boolean moreValues, boolean limitReached) {
            this.moreValues = moreValues;
            this.limitReached = limitReached;
        }

        public boolean hasMoreValues() {
            return this.moreValues;
        }

        public boolean limitReached() {
            return this.limitReached;
        }

        public static boolean isValidState(NextState state) {
            return state != null;
        }

        public static boolean hasMoreValues(NextState state) {
            return NextState.isValidState(state) && state.hasMoreValues();
        }
    }

    public static final class Builder {
        boolean keepProgress = ScannerContext.access$200();
        boolean trackMetrics = false;
        LimitFields limits = new LimitFields();
        ServerSideScanMetrics scanMetrics = null;

        private Builder() {
        }

        private Builder(boolean keepProgress) {
            this.keepProgress = keepProgress;
        }

        public Builder setKeepProgress(boolean keepProgress) {
            this.keepProgress = keepProgress;
            return this;
        }

        public Builder setTrackMetrics(boolean trackMetrics) {
            this.trackMetrics = trackMetrics;
            return this;
        }

        public Builder setSizeLimit(LimitScope sizeScope, long dataSizeLimit, long heapSizeLimit) {
            this.limits.setDataSize(dataSizeLimit);
            this.limits.setHeapSize(heapSizeLimit);
            this.limits.setSizeScope(sizeScope);
            return this;
        }

        public Builder setTimeLimit(LimitScope timeScope, long timeLimit) {
            this.limits.setTime(timeLimit);
            this.limits.setTimeScope(timeScope);
            return this;
        }

        public Builder setBatchLimit(int batchLimit) {
            this.limits.setBatch(batchLimit);
            return this;
        }

        public Builder setScanMetrics(ServerSideScanMetrics scanMetrics) {
            this.scanMetrics = scanMetrics;
            return this;
        }

        public ScannerContext build() {
            return new ScannerContext(this.keepProgress, this.limits, this.trackMetrics, this.scanMetrics);
        }
    }
}

