/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestScannerWithCorruptHFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerWithCorruptHFile.class);
    @Rule
    public TestName name = new TestName();
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"f");
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=DoNotRetryIOException.class)
    public void testScanOnCorruptHFile() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addCoprocessor(CorruptHFileCoprocessor.class.getName());
        htd.addFamily(new HColumnDescriptor(FAMILY_NAME));
        try (Table table = TEST_UTIL.createTable((TableDescriptor)htd, (byte[][])null);){
            this.loadTable(table, 1);
            this.scan(table);
        }
    }

    private void loadTable(Table table, int numRows) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            byte[] row = Bytes.toBytes((int)i);
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(FAMILY_NAME, null, row);
            table.put(put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(Table table) throws IOException {
        Scan scan = new Scan();
        scan.setCaching(1);
        scan.setCacheBlocks(false);
        try (ResultScanner scanner = table.getScanner(scan);){
            scanner.next();
        }
    }

    public static class CorruptHFileCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            throw new CorruptHFileException("For test");
        }
    }
}

