/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableRegionReplicasRead;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableRegionReplicasGet
extends AbstractTestAsyncTableRegionReplicasRead {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableRegionReplicasGet.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestAsyncTableRegionReplicasGet.startClusterAndCreateTable();
        AsyncTable table = ASYNC_CONN.getTable(TABLE_NAME);
        table.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE)).get();
        TestAsyncTableRegionReplicasGet.waitUntilAllReplicasHaveRow(ROW);
    }

    @Override
    protected void readAndCheck(AsyncTable<?> table, int replicaId) throws Exception {
        Get get = new Get(ROW).setConsistency(Consistency.TIMELINE);
        if (replicaId >= 0) {
            get.setReplicaId(replicaId);
        }
        Assert.assertArrayEquals((byte[])VALUE, (byte[])((Result)table.get(get).get()).getValue(FAMILY, QUALIFIER));
    }
}

