/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.ElementHolder;
import org.apache.directory.mavibot.btree.Leaf;
import org.apache.directory.mavibot.btree.MemoryHolder;
import org.apache.directory.mavibot.btree.Node;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

public class BTreeBuilder<K, V> {
    private String name;
    private int numKeysInNode;
    private ElementSerializer<K> keySerializer;
    private ElementSerializer<V> valueSerializer;

    public BTreeBuilder(String name, int numKeysInNode, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer) {
        this.name = name;
        this.numKeysInNode = numKeysInNode;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public BTree<K, V> build(Iterator<Tuple<K, V>> sortedTupleItr) throws IOException {
        BTree<K, V> btree = new BTree<K, V>(this.name, this.keySerializer, this.valueSerializer);
        btree.init();
        ArrayList<Page<K, V>> lstLeaves = new ArrayList<Page<K, V>>();
        int totalTupleCount = 0;
        Leaf leaf1 = BTreeFactory.createLeaf(btree, 0L, this.numKeysInNode);
        lstLeaves.add(leaf1);
        int leafIndex = 0;
        while (sortedTupleItr.hasNext()) {
            Tuple<K, V> tuple = sortedTupleItr.next();
            BTreeFactory.setKey(leaf1, leafIndex, tuple.getKey());
            MemoryHolder<K, V> eh = new MemoryHolder<K, V>(btree, tuple.getValue());
            BTreeFactory.setValue(leaf1, leafIndex, eh);
            ++leafIndex;
            if (++totalTupleCount % this.numKeysInNode != 0) continue;
            leafIndex = 0;
            leaf1 = BTreeFactory.createLeaf(btree, 0L, this.numKeysInNode);
            lstLeaves.add(leaf1);
        }
        if (lstLeaves.isEmpty()) {
            return btree;
        }
        Leaf lastLeaf = (Leaf)lstLeaves.get(lstLeaves.size() - 1);
        for (int i = 0; i < lastLeaf.nbElems; ++i) {
            int n;
            if (lastLeaf.keys[i] != null) continue;
            lastLeaf.nbElems = n = i;
            Object[] keys = lastLeaf.keys;
            Class<?> keyType = btree.getKeyType();
            lastLeaf.keys = (Object[])Array.newInstance(keyType, n);
            System.arraycopy(keys, 0, lastLeaf.keys, 0, n);
            ElementHolder<V, K, V>[] values = lastLeaf.values;
            lastLeaf.values = (MemoryHolder[])Array.newInstance(MemoryHolder.class, n);
            System.arraycopy(values, 0, lastLeaf.values, 0, n);
            break;
        }
        Page<K, V> rootPage = this.attachNodes(lstLeaves, btree);
        btree.rootPage = rootPage;
        return btree;
    }

    private Page<K, V> attachNodes(List<Page<K, V>> children, BTree btree) throws IOException {
        if (children.size() == 1) {
            return children.get(0);
        }
        ArrayList<Page<K, V>> lstNodes = new ArrayList<Page<K, V>>();
        int numChildren = this.numKeysInNode + 1;
        Node node = BTreeFactory.createNode(btree, 0L, this.numKeysInNode);
        lstNodes.add(node);
        int i = 0;
        int totalNodes = 0;
        for (Page<K, V> p : children) {
            if (i != 0) {
                BTreeFactory.setKey(node, i - 1, p.getLeftMostKey());
            }
            node.children[i] = btree.createHolder(p);
            ++i;
            if (++totalNodes % numChildren != 0) continue;
            i = 0;
            node = BTreeFactory.createNode(btree, 0L, this.numKeysInNode);
            lstNodes.add(node);
        }
        AbstractPage lastNode = (AbstractPage)lstNodes.get(lstNodes.size() - 1);
        for (int j = 0; j < lastNode.nbElems; ++j) {
            int n;
            if (lastNode.keys[j] != null) continue;
            lastNode.nbElems = n = j;
            K[] keys = lastNode.keys;
            Class<?> keyType = btree.getKeyType();
            lastNode.keys = (Object[])Array.newInstance(keyType, n);
            System.arraycopy(keys, 0, lastNode.keys, 0, n);
            break;
        }
        return this.attachNodes(lstNodes, btree);
    }
}

