/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.master.replication.AbstractPeerProcedure;
import org.apache.hadoop.hbase.master.replication.RefreshPeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ModifyPeerProcedure
extends AbstractPeerProcedure<MasterProcedureProtos.PeerModificationState> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyPeerProcedure.class);
    protected static final int UPDATE_LAST_SEQ_ID_BATCH_SIZE = 1000;
    protected static final int SLEEP_INTERVAL_MS = 1000;
    private RetryCounter retryCounter;

    protected ModifyPeerProcedure() {
    }

    protected ModifyPeerProcedure(String peerId) {
        super(peerId);
    }

    protected abstract void prePeerModification(MasterProcedureEnv var1) throws IOException, ReplicationException;

    protected abstract void updatePeerStorage(MasterProcedureEnv var1) throws ReplicationException;

    protected abstract void postPeerModification(MasterProcedureEnv var1) throws IOException, ReplicationException;

    private void releaseLatch() {
        ProcedurePrepareLatch.releaseLatch(this.latch, this);
    }

    protected MasterProcedureProtos.PeerModificationState nextStateAfterRefresh() {
        return MasterProcedureProtos.PeerModificationState.POST_PEER_MODIFICATION;
    }

    protected boolean enablePeerBeforeFinish() {
        throw new UnsupportedOperationException();
    }

    private void refreshPeer(MasterProcedureEnv env, PeerProcedureInterface.PeerOperationType type) {
        this.addChildProcedure((Procedure[])env.getMasterServices().getServerManager().getOnlineServersList().stream().map(sn -> new RefreshPeerProcedure(this.peerId, type, (ServerName)sn)).toArray(RefreshPeerProcedure[]::new));
    }

    protected ReplicationPeerConfig getOldPeerConfig() {
        return null;
    }

    protected ReplicationPeerConfig getNewPeerConfig() {
        throw new UnsupportedOperationException();
    }

    protected void updateLastPushedSequenceIdForSerialPeer(MasterProcedureEnv env) throws IOException, ReplicationException {
        throw new UnsupportedOperationException();
    }

    private boolean needReopen(TableStateManager tsm, TableName tn) throws IOException {
        try {
            while (true) {
                TableState state;
                if ((state = tsm.getTableState(tn)).isEnabled()) {
                    return true;
                }
                if (!state.isEnabling()) {
                    return false;
                }
                Thread.sleep(1000L);
            }
        }
        catch (TableNotFoundException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    protected void reopenRegions(MasterProcedureEnv env) throws IOException {
        ReplicationPeerConfig peerConfig = this.getNewPeerConfig();
        ReplicationPeerConfig oldPeerConfig = this.getOldPeerConfig();
        TableStateManager tsm = env.getMasterServices().getTableStateManager();
        for (TableDescriptor td : env.getMasterServices().getTableDescriptors().getAll().values()) {
            TableName tn;
            if (!td.hasGlobalReplicationScope() || !peerConfig.needToReplicate(tn = td.getTableName()) || oldPeerConfig != null && oldPeerConfig.isSerial() && oldPeerConfig.needToReplicate(tn) || !this.needReopen(tsm, tn)) continue;
            this.addChildProcedure(new ReopenTableRegionsProcedure[]{new ReopenTableRegionsProcedure(tn)});
        }
    }

    protected void enablePeer(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().enablePeer(this.peerId);
    }

    private void addToMap(Map<String, Long> lastSeqIds, String encodedRegionName, long barrier, ReplicationQueueStorage queueStorage) throws ReplicationException {
        if (barrier >= 0L) {
            lastSeqIds.put(encodedRegionName, barrier);
            if (lastSeqIds.size() >= 1000) {
                queueStorage.setLastSequenceIds(this.peerId, lastSeqIds);
                lastSeqIds.clear();
            }
        }
    }

    protected final void setLastPushedSequenceId(MasterProcedureEnv env, ReplicationPeerConfig peerConfig) throws IOException, ReplicationException {
        HashMap<String, Long> lastSeqIds = new HashMap<String, Long>();
        for (TableDescriptor td : env.getMasterServices().getTableDescriptors().getAll().values()) {
            TableName tn;
            if (!td.hasGlobalReplicationScope() || !peerConfig.needToReplicate(tn = td.getTableName())) continue;
            this.setLastPushedSequenceIdForTable(env, tn, lastSeqIds);
        }
        if (!lastSeqIds.isEmpty()) {
            env.getReplicationPeerManager().getQueueStorage().setLastSequenceIds(this.peerId, lastSeqIds);
        }
    }

    private boolean needSetLastPushedSequenceId(TableStateManager tsm, TableName tn) throws IOException {
        try {
            while (true) {
                if (!tsm.getTableState(tn).isDisabling()) {
                    return true;
                }
                Thread.sleep(1000L);
            }
        }
        catch (TableNotFoundException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    protected final void setLastPushedSequenceIdForTable(MasterProcedureEnv env, TableName tableName, Map<String, Long> lastSeqIds) throws IOException, ReplicationException {
        TableStateManager tsm = env.getMasterServices().getTableStateManager();
        ReplicationQueueStorage queueStorage = env.getReplicationPeerManager().getQueueStorage();
        Connection conn = env.getMasterServices().getConnection();
        if (!this.needSetLastPushedSequenceId(tsm, tableName)) {
            LOG.debug("Skip settting last pushed sequence id for {}", (Object)tableName);
            return;
        }
        for (Pair<String, Long> name2Barrier : MetaTableAccessor.getTableEncodedRegionNameAndLastBarrier(conn, tableName)) {
            LOG.trace("Update last pushed sequence id for {}, {}", (Object)tableName, name2Barrier);
            this.addToMap(lastSeqIds, name2Barrier.getFirst(), name2Barrier.getSecond() - 1L, queueStorage);
        }
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    private ProcedureSuspendedException suspend(Configuration conf, LongConsumer backoffConsumer) throws ProcedureSuspendedException {
        if (this.retryCounter == null) {
            this.retryCounter = ProcedureUtil.createRetryCounter(conf);
        }
        long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
        backoffConsumer.accept(backoff);
        this.setTimeout(Math.toIntExact(backoff));
        this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.skipPersistence();
        throw new ProcedureSuspendedException();
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.PeerModificationState state) throws ProcedureSuspendedException {
        switch (state) {
            case PRE_PEER_MODIFICATION: {
                try {
                    this.prePeerModification(env);
                }
                catch (IOException e) {
                    LOG.warn("{} failed to call pre CP hook or the pre check is failed for peer {}, mark the procedure as failure and give up", new Object[]{this.getClass().getName(), this.peerId, e});
                    this.setFailure("master-" + this.getPeerOperationType().name().toLowerCase() + "-peer", e);
                    this.releaseLatch();
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("{} failed to call prePeerModification for peer {}, sleep {} secs", new Object[]{this.getClass().getName(), this.peerId, backoff / 1000L, e}));
                }
                this.retryCounter = null;
                this.setNextState(MasterProcedureProtos.PeerModificationState.UPDATE_PEER_STORAGE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case UPDATE_PEER_STORAGE: {
                try {
                    this.updatePeerStorage(env);
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("{} update peer storage for peer {} failed, sleep {} secs", new Object[]{this.getClass().getName(), this.peerId, backoff / 1000L, e}));
                }
                this.retryCounter = null;
                this.setNextState(MasterProcedureProtos.PeerModificationState.REFRESH_PEER_ON_RS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REFRESH_PEER_ON_RS: {
                this.refreshPeer(env, this.getPeerOperationType());
                this.setNextState(this.nextStateAfterRefresh());
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SERIAL_PEER_REOPEN_REGIONS: {
                try {
                    this.reopenRegions(env);
                }
                catch (Exception e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("{} reopen regions for peer {} failed,  sleep {} secs", new Object[]{this.getClass().getName(), this.peerId, backoff / 1000L, e}));
                }
                this.retryCounter = null;
                this.setNextState(MasterProcedureProtos.PeerModificationState.SERIAL_PEER_UPDATE_LAST_PUSHED_SEQ_ID);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SERIAL_PEER_UPDATE_LAST_PUSHED_SEQ_ID: {
                try {
                    this.updateLastPushedSequenceIdForSerialPeer(env);
                }
                catch (Exception e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("{} set last sequence id for peer {} failed,  sleep {} secs", new Object[]{this.getClass().getName(), this.peerId, backoff / 1000L, e}));
                }
                this.retryCounter = null;
                this.setNextState(this.enablePeerBeforeFinish() ? MasterProcedureProtos.PeerModificationState.SERIAL_PEER_SET_PEER_ENABLED : MasterProcedureProtos.PeerModificationState.POST_PEER_MODIFICATION);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SERIAL_PEER_SET_PEER_ENABLED: {
                try {
                    this.enablePeer(env);
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("{} enable peer before finish for peer {} failed,  sleep {} secs", new Object[]{this.getClass().getName(), this.peerId, backoff / 1000L, e}));
                }
                this.retryCounter = null;
                this.setNextState(MasterProcedureProtos.PeerModificationState.SERIAL_PEER_ENABLE_PEER_REFRESH_PEER_ON_RS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SERIAL_PEER_ENABLE_PEER_REFRESH_PEER_ON_RS: {
                this.refreshPeer(env, PeerProcedureInterface.PeerOperationType.ENABLE);
                this.setNextState(MasterProcedureProtos.PeerModificationState.POST_PEER_MODIFICATION);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case POST_PEER_MODIFICATION: {
                try {
                    this.postPeerModification(env);
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("{} failed to call postPeerModification for peer {},  sleep {} secs", new Object[]{this.getClass().getName(), this.peerId, backoff / 1000L, e}));
                }
                catch (IOException e) {
                    LOG.warn("{} failed to call post CP hook for peer {}, ignore since the procedure has already done", new Object[]{this.getClass().getName(), this.peerId, e});
                }
                this.releaseLatch();
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.PeerModificationState state) throws IOException, InterruptedException {
        if (state == MasterProcedureProtos.PeerModificationState.PRE_PEER_MODIFICATION) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected MasterProcedureProtos.PeerModificationState getState(int stateId) {
        return MasterProcedureProtos.PeerModificationState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.PeerModificationState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.PeerModificationState getInitialState() {
        return MasterProcedureProtos.PeerModificationState.PRE_PEER_MODIFICATION;
    }
}

