/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCommonFSUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCommonFSUtils.class);
    private HBaseCommonTestingUtility htu;
    private Configuration conf;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.conf = this.htu.getConfiguration();
    }

    @Test
    public void testMatchingTail() throws IOException {
        Path rootdir = this.htu.getDataTestDir();
        FileSystem fs = rootdir.getFileSystem(this.conf);
        Assert.assertTrue((rootdir.depth() > 1 ? 1 : 0) != 0);
        Path partPath = new Path("a", "b");
        Path fullPath = new Path(rootdir, partPath);
        Path fullyQualifiedPath = fs.makeQualified(fullPath);
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullPath, (Path)partPath));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullPath, (String)partPath.toString()));
        Assert.assertTrue((boolean)CommonFSUtils.isStartingWithPath((Path)rootdir, (String)fullPath.toString()));
        Assert.assertTrue((boolean)CommonFSUtils.isStartingWithPath((Path)fullyQualifiedPath, (String)fullPath.toString()));
        Assert.assertFalse((boolean)CommonFSUtils.isStartingWithPath((Path)rootdir, (String)partPath.toString()));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)partPath));
        Assert.assertTrue((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)fullPath));
        Assert.assertTrue((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (String)fullPath.toString()));
        Assert.assertTrue((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)fs.makeQualified(fullPath)));
        Assert.assertTrue((boolean)CommonFSUtils.isStartingWithPath((Path)rootdir, (String)fullyQualifiedPath.toString()));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullPath, (Path)new Path("x")));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)new Path("x"), (Path)fullPath));
    }

    @Test
    public void testSetWALRootDir() throws Exception {
        Path p = new Path("file:///hbase/root");
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)p);
        Assert.assertEquals((Object)p.toString(), (Object)this.conf.get("hbase.wal.dir"));
    }

    @Test
    public void testGetWALRootDir() throws IOException {
        Path root = new Path("file:///hbase/root");
        Path walRoot = new Path("file:///hbase/logroot");
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)root);
        Assert.assertEquals((Object)root, (Object)CommonFSUtils.getRootDir((Configuration)this.conf));
        Assert.assertEquals((Object)root, (Object)CommonFSUtils.getWALRootDir((Configuration)this.conf));
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)walRoot);
        Assert.assertEquals((Object)walRoot, (Object)CommonFSUtils.getWALRootDir((Configuration)this.conf));
    }

    @Test
    public void testGetWALRootDirUsingUri() throws IOException {
        Path root = new Path("file:///hbase/root");
        this.conf.set("hbase.rootdir", root.toString());
        Path walRoot = new Path("file:///hbase/logroot");
        this.conf.set("hbase.wal.dir", walRoot.toString());
        String walDirUri = CommonFSUtils.getDirUri((Configuration)this.conf, (Path)walRoot);
        String rootDirUri = CommonFSUtils.getDirUri((Configuration)this.conf, (Path)root);
        CommonFSUtils.setFsDefault((Configuration)this.conf, (String)rootDirUri);
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)root);
        Assert.assertEquals((Object)root, (Object)CommonFSUtils.getRootDir((Configuration)this.conf));
        CommonFSUtils.setFsDefault((Configuration)this.conf, (String)walDirUri);
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)walRoot);
        Assert.assertEquals((Object)walRoot, (Object)CommonFSUtils.getWALRootDir((Configuration)this.conf));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetWALRootDirIllegalWALDir() throws IOException {
        Path root = new Path("file:///hbase/root");
        Path invalidWALDir = new Path("file:///hbase/root/logroot");
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)root);
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)invalidWALDir);
        CommonFSUtils.getWALRootDir((Configuration)this.conf);
    }

    @Test
    public void testRemoveWALRootPath() throws Exception {
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)new Path("file:///user/hbase"));
        Path testFile = new Path(CommonFSUtils.getRootDir((Configuration)this.conf), "test/testfile");
        Path tmpFile = new Path("file:///test/testfile");
        Assert.assertEquals((Object)"test/testfile", (Object)CommonFSUtils.removeWALRootPath((Path)testFile, (Configuration)this.conf));
        Assert.assertEquals((Object)tmpFile.toString(), (Object)CommonFSUtils.removeWALRootPath((Path)tmpFile, (Configuration)this.conf));
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)new Path("file:///user/hbaseLogDir"));
        Assert.assertEquals((Object)testFile.toString(), (Object)CommonFSUtils.removeWALRootPath((Path)testFile, (Configuration)this.conf));
        Path logFile = new Path(CommonFSUtils.getWALRootDir((Configuration)this.conf), "test/testlog");
        Assert.assertEquals((Object)"test/testlog", (Object)CommonFSUtils.removeWALRootPath((Path)logFile, (Configuration)this.conf));
    }
}

