/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.api;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.impl.RegistryOperationsClient;

public final class RegistryOperationsFactory {
    private RegistryOperationsFactory() {
    }

    public static RegistryOperations createInstance(Configuration conf) {
        return RegistryOperationsFactory.createInstance("RegistryOperations", conf);
    }

    public static RegistryOperations createInstance(String name, Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        RegistryOperationsClient operations = new RegistryOperationsClient(name);
        operations.init(conf);
        return operations;
    }

    public static RegistryOperations createAnonymousInstance(Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        conf.set("hadoop.registry.client.auth", "");
        return RegistryOperationsFactory.createInstance("AnonymousRegistryOperations", conf);
    }

    public static RegistryOperations createKerberosInstance(Configuration conf, String jaasContext) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        conf.set("hadoop.registry.client.auth", "kerberos");
        conf.set("hadoop.registry.jaas.context", jaasContext);
        return RegistryOperationsFactory.createInstance("KerberosRegistryOperations", conf);
    }

    public static RegistryOperations createAuthenticatedInstance(Configuration conf, String id, String password) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)id) ? 1 : 0) != 0, (Object)"empty Id");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)password) ? 1 : 0) != 0, (Object)"empty Password");
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        conf.set("hadoop.registry.client.auth", "digest");
        conf.set("hadoop.registry.client.auth.id", id);
        conf.set("hadoop.registry.client.auth.password", password);
        return RegistryOperationsFactory.createInstance("DigestRegistryOperations", conf);
    }
}

