/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, LargeTests.class})
public class TestScannerSelectionUsingTTL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerSelectionUsingTTL.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestScannerSelectionUsingTTL.class);
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static TableName TABLE = TableName.valueOf((String)"myTable");
    private static String FAMILY = "myCF";
    private static byte[] FAMILY_BYTES = Bytes.toBytes((String)FAMILY);
    private static final int TTL_SECONDS = 10;
    private static final int TTL_MS = 10000;
    private static final int NUM_EXPIRED_FILES = 2;
    private static final int NUM_ROWS = 8;
    private static final int NUM_COLS_PER_ROW = 5;
    public final int numFreshFiles;
    public final int totalNumFiles;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int numFreshFiles = 1; numFreshFiles <= 3; ++numFreshFiles) {
            params.add(new Object[]{numFreshFiles});
        }
        return params;
    }

    public TestScannerSelectionUsingTTL(int numFreshFiles) {
        this.numFreshFiles = numFreshFiles;
        this.totalNumFiles = numFreshFiles + 2;
    }

    @Test
    public void testScannerSelection() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.store.delete.expired.storefile", false);
        LruBlockCache cache = (LruBlockCache)BlockCacheFactory.createBlockCache((Configuration)conf);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_BYTES).setMaxVersions(Integer.MAX_VALUE).setTimeToLive(10).build()).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)TABLE).build();
        HRegion region = HBaseTestingUtility.createRegionAndWAL(info, TEST_UTIL.getDataTestDir(info.getEncodedName()), conf, td, (BlockCache)cache);
        long ts = EnvironmentEdgeManager.currentTime();
        long version = 0L;
        for (int iFile = 0; iFile < this.totalNumFiles; ++iFile) {
            if (iFile == 2) {
                Threads.sleepWithoutInterrupt((long)10000L);
                version += 10000L;
            }
            for (int iRow = 0; iRow < 8; ++iRow) {
                Put put = new Put(Bytes.toBytes((String)("row" + iRow)));
                for (int iCol = 0; iCol < 5; ++iCol) {
                    put.addColumn(FAMILY_BYTES, Bytes.toBytes((String)("col" + iCol)), ts + version, Bytes.toBytes((String)("value" + iFile + "_" + iRow + "_" + iCol)));
                }
                region.put(put);
            }
            region.flush(true);
            ++version;
        }
        Scan scan = new Scan().readVersions(Integer.MAX_VALUE);
        cache.clearCache();
        RegionScannerImpl scanner = region.getScanner(scan);
        ArrayList results = new ArrayList();
        int expectedKVsPerRow = this.numFreshFiles * 5;
        int numReturnedRows = 0;
        LOG.info("Scanning the entire table");
        while (scanner.next(results) || results.size() > 0) {
            Assert.assertEquals((long)expectedKVsPerRow, (long)results.size());
            ++numReturnedRows;
            results.clear();
        }
        Assert.assertEquals((long)8L, (long)numReturnedRows);
        SortedSet accessedFiles = cache.getCachedFileNamesForTest();
        LOG.debug("Files accessed during scan: " + accessedFiles);
        region.compact(false);
        HBaseTestingUtility.closeRegionAndWAL(region);
    }
}

