/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CloseChecker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSetMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hbase.thirdparty.com.google.common.collect.SetMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultMobStoreCompactor
extends DefaultCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMobStoreCompactor.class);
    protected long mobSizeThreshold;
    protected HMobStore mobStore;
    protected boolean ioOptimizedMode = false;
    static ThreadLocal<SetMultimap<TableName, String>> mobRefSet = ThreadLocal.withInitial(HashMultimap::create);
    static ThreadLocal<Boolean> userRequest = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    static ThreadLocal<Boolean> disableIO = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    static ThreadLocal<HashMap<String, Long>> mobLengthMap = new ThreadLocal<HashMap<String, Long>>(){

        @Override
        protected HashMap<String, Long> initialValue() {
            return new HashMap<String, Long>();
        }
    };
    private final Compactor.InternalScannerFactory scannerFactory = new Compactor.InternalScannerFactory(){

        @Override
        public ScanType getScanType(CompactionRequestImpl request) {
            return request.isAllFiles() ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
        }

        @Override
        public InternalScanner createScanner(ScanInfo scanInfo, List<StoreFileScanner> scanners, ScanType scanType, Compactor.FileDetails fd, long smallestReadPoint) throws IOException {
            return new StoreScanner(DefaultMobStoreCompactor.this.store, scanInfo, scanners, scanType, smallestReadPoint, fd.earliestPutTs);
        }
    };
    private final Compactor.CellSinkFactory<StoreFileWriter> writerFactory = new Compactor.CellSinkFactory<StoreFileWriter>(){

        @Override
        public StoreFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind, boolean major, Consumer<Path> writerCreationTracker) throws IOException {
            return DefaultMobStoreCompactor.this.store.getStoreEngine().createWriter(DefaultMobStoreCompactor.this.createParams(fd, shouldDropBehind, major, writerCreationTracker).includeMVCCReadpoint(true).includesTag(true));
        }
    };

    public DefaultMobStoreCompactor(Configuration conf, HStore store) {
        super(conf, store);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobStore = (HMobStore)store;
        this.mobSizeThreshold = store.getColumnFamilyDescriptor().getMobThreshold();
        this.ioOptimizedMode = conf.get("hbase.mob.compaction.type", "full").equals("optimized");
    }

    @Override
    public List<Path> compact(CompactionRequestImpl request, ThroughputController throughputController, User user) throws IOException {
        String tableName = this.store.getTableName().toString();
        String regionName = this.store.getRegionInfo().getRegionNameAsString();
        String familyName = this.store.getColumnFamilyName();
        LOG.info("MOB compaction: major={} isAll={} priority={} throughput controller={} table={} cf={} region={}", new Object[]{request.isMajor(), request.isAllFiles(), request.getPriority(), throughputController, tableName, familyName, regionName});
        if (request.getPriority() == 1) {
            userRequest.set(Boolean.TRUE);
        } else {
            userRequest.set(Boolean.FALSE);
        }
        LOG.debug("MOB compaction table={} cf={} region={} files: {}", new Object[]{tableName, familyName, regionName, request.getFiles()});
        if (this.ioOptimizedMode && request.isMajor() && request.getPriority() == 1) {
            try {
                ImmutableSetMultimap mobRefs = request.getFiles().stream().map(file -> {
                    ImmutableSetMultimap.Builder<TableName, String> builder;
                    byte[] value = file.getMetadataValue(HStoreFile.MOB_FILE_REFS);
                    if (value == null) {
                        builder = ImmutableSetMultimap.builder();
                    } else {
                        try {
                            builder = MobUtils.deserializeMobFileRefs(value);
                        }
                        catch (RuntimeException exception) {
                            throw new RuntimeException("failure getting mob references for hfile " + file, exception);
                        }
                    }
                    return builder;
                }).reduce((a, b) -> a.putAll((Multimap)b.build())).orElseGet(ImmutableSetMultimap::builder).build();
                disableIO.set(Boolean.FALSE);
                if (!mobRefs.isEmpty()) {
                    this.calculateMobLengthMap((SetMultimap<TableName, String>)mobRefs);
                }
                LOG.info("Table={} cf={} region={}. I/O optimized MOB compaction. Total referenced MOB files: {}", new Object[]{tableName, familyName, regionName, mobRefs.size()});
            }
            catch (RuntimeException exception) {
                throw new IOException("Failed to get list of referenced hfiles for request " + request, exception);
            }
        }
        return this.compact(request, this.scannerFactory, this.writerFactory, throughputController, user);
    }

    private void calculateMobLengthMap(SetMultimap<TableName, String> mobRefs) throws IOException {
        FileSystem fs = this.store.getFileSystem();
        HashMap<String, Long> map = mobLengthMap.get();
        map.clear();
        for (Map.Entry reference : mobRefs.entries()) {
            TableName table = (TableName)reference.getKey();
            String mobfile = (String)reference.getValue();
            if (MobFileName.isOldMobFileName(mobfile)) {
                disableIO.set(Boolean.TRUE);
            }
            List<Path> locations = this.mobStore.getLocations(table);
            for (Path p : locations) {
                try {
                    FileStatus st = fs.getFileStatus(new Path(p, mobfile));
                    long size = st.getLen();
                    LOG.debug("Referenced MOB file={} size={}", (Object)mobfile, (Object)size);
                    map.put(mobfile, size);
                    break;
                }
                catch (FileNotFoundException exception) {
                    LOG.debug("Mob file {} was not in location {}. May have other locations to try.", (Object)mobfile, (Object)p);
                }
            }
            if (map.containsKey(mobfile)) continue;
            throw new FileNotFoundException("Could not find mob file " + mobfile + " in the list of expected locations: " + locations);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean performCompaction(Compactor.FileDetails fd, InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController, CompactionRequestImpl request, CompactionProgress progress) throws IOException {
        long bytesWrittenProgressForLog = 0L;
        long bytesWrittenProgressForShippedCall = 0L;
        mobRefSet.get().clear();
        boolean isUserRequest = userRequest.get();
        boolean major = request.isAllFiles();
        boolean compactMOBs = major && isUserRequest;
        boolean discardMobMiss = this.conf.getBoolean("hbase.unsafe.mob.discard.miss", false);
        if (discardMobMiss) {
            LOG.warn("{}=true. This is unsafe setting recommended only when first upgrading to a version with the distributed mob compaction feature on a cluster that has experienced MOB data corruption.", (Object)"hbase.unsafe.mob.discard.miss");
        }
        long maxMobFileSize = this.conf.getLong("hbase.mob.compactions.max.file.size", 0x40000000L);
        boolean ioOptimizedMode = this.ioOptimizedMode && disableIO.get() == false;
        LOG.info("Compact MOB={} optimized configured={} optimized enabled={} maximum MOB file size={} major={} store={}", new Object[]{compactMOBs, this.ioOptimizedMode, ioOptimizedMode, maxMobFileSize, major, this.getStoreInfo()});
        ArrayList<Cell> cells = new ArrayList<Cell>();
        long currentTime = EnvironmentEdgeManager.currentTime();
        long lastMillis = 0L;
        if (LOG.isDebugEnabled()) {
            lastMillis = currentTime;
        }
        CloseChecker closeChecker = new CloseChecker(this.conf, currentTime);
        String compactionName = ThroughputControlUtil.getNameForThrottling(this.store, "compaction");
        long now = 0L;
        byte[] fileName = null;
        StoreFileWriter mobFileWriter = null;
        long mobCells = 0L;
        long cellsCountCompactedToMob = 0L;
        long cellsCountCompactedFromMob = 0L;
        long cellsSizeCompactedToMob = 0L;
        long cellsSizeCompactedFromMob = 0L;
        boolean finished = false;
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
        throughputController.start(compactionName);
        KeyValueScanner kvs = scanner instanceof KeyValueScanner ? (KeyValueScanner)((Object)scanner) : null;
        long shippedCallSizeLimit = (long)request.getFiles().size() * (long)this.store.getColumnFamilyDescriptor().getBlocksize();
        Cell mobCell = null;
        ArrayList<String> committedMobWriterFileNames = new ArrayList<String>();
        try {
            boolean hasMore;
            mobFileWriter = this.newMobWriter(fd, major, request.getWriterCreationTracker());
            fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
            do {
                hasMore = scanner.next(cells, scannerContext);
                now = EnvironmentEdgeManager.currentTime();
                for (Cell c : cells) {
                    block41: {
                        block37: {
                            block38: {
                                block39: {
                                    String fName;
                                    block40: {
                                        if (!compactMOBs) break block37;
                                        if (!MobUtils.isMobReferenceCell(c)) break block38;
                                        fName = MobUtils.getMobFileName(c);
                                        try {
                                            mobCell = this.mobStore.resolve(c, true, false).getCell();
                                        }
                                        catch (FileNotFoundException fnfe) {
                                            if (!discardMobMiss) throw fnfe;
                                            LOG.error("Missing MOB cell: file={} not found cell={}", (Object)fName, (Object)c);
                                            continue;
                                        }
                                        if (discardMobMiss && mobCell.getValueLength() == 0) {
                                            LOG.error("Missing MOB cell value: file={} mob cell={} cell={}", new Object[]{fName, mobCell, c});
                                            continue;
                                        }
                                        if (mobCell.getValueLength() == 0) {
                                            String errMsg = String.format("Found 0 length MOB cell in a file=%s mob cell=%s  cell=%s", fName, mobCell, c);
                                            throw new IOException(errMsg);
                                        }
                                        if ((long)mobCell.getValueLength() <= this.mobSizeThreshold) break block39;
                                        PrivateCellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                        if (ioOptimizedMode) break block40;
                                        mobFileWriter.append(mobCell);
                                        ++mobCells;
                                        writer.append(MobUtils.createMobRefCell(mobCell, fileName, this.mobStore.getRefCellTags()));
                                        break block41;
                                    }
                                    Long size = mobLengthMap.get().get(fName);
                                    if (size == null) {
                                        String msg = String.format("Found an unexpected MOB file during compaction %s, aborting compaction %s", fName, this.getStoreInfo());
                                        throw new IOException(msg);
                                    }
                                    if (size < maxMobFileSize) {
                                        mobFileWriter.append(mobCell);
                                        ++mobCells;
                                        writer.append(MobUtils.createMobRefCell(mobCell, fileName, this.mobStore.getRefCellTags()));
                                        long len = mobFileWriter.getPos();
                                        if (len > maxMobFileSize) {
                                            LOG.debug("Closing output MOB File, length={} file={}, store={}", new Object[]{len, mobFileWriter.getPath().getName(), this.getStoreInfo()});
                                            mobFileWriter = this.switchToNewMobWriter(mobFileWriter, fd, mobCells, major, request, committedMobWriterFileNames);
                                            fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
                                            mobCells = 0L;
                                        }
                                        break block41;
                                    } else {
                                        Optional<TableName> refTable = MobUtils.getTableName(c);
                                        if (!refTable.isPresent()) {
                                            throw new IOException(String.format("MOB cell did not contain a tablename tag. should not be possible. see ref guide on mob troubleshooting. store=%s cell=%s", this.getStoreInfo(), c));
                                        }
                                        mobRefSet.get().put((Object)refTable.get(), (Object)fName);
                                        writer.append(c);
                                    }
                                    break block41;
                                }
                                PrivateCellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                writer.append(mobCell);
                                ++cellsCountCompactedFromMob;
                                cellsSizeCompactedFromMob += (long)mobCell.getValueLength();
                                break block41;
                            }
                            int size = c.getValueLength();
                            if ((long)size > this.mobSizeThreshold) {
                                long len;
                                mobFileWriter.append(c);
                                writer.append(MobUtils.createMobRefCell(c, fileName, this.mobStore.getRefCellTags()));
                                ++mobCells;
                                ++cellsCountCompactedToMob;
                                cellsSizeCompactedToMob += (long)c.getValueLength();
                                if (ioOptimizedMode && (len = mobFileWriter.getPos()) > maxMobFileSize) {
                                    mobFileWriter = this.switchToNewMobWriter(mobFileWriter, fd, mobCells, major, request, committedMobWriterFileNames);
                                    fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
                                    mobCells = 0L;
                                }
                                break block41;
                            } else {
                                writer.append(c);
                            }
                            break block41;
                        }
                        if (c.getTypeByte() != KeyValue.Type.Put.getCode()) {
                            writer.append(c);
                        } else if (MobUtils.isMobReferenceCell(c)) {
                            if (!MobUtils.hasValidMobRefCellValue(c)) {
                                String errMsg = String.format("Corrupted MOB reference: %s", c.toString());
                                throw new IOException(errMsg);
                            }
                            Optional<TableName> refTable = MobUtils.getTableName(c);
                            if (!refTable.isPresent()) {
                                throw new IOException(String.format("MOB cell did not contain a tablename tag. should not be possible. see ref guide on mob troubleshooting. store=%s cell=%s", this.getStoreInfo(), c));
                            }
                            mobRefSet.get().put((Object)refTable.get(), (Object)MobUtils.getMobFileName(c));
                            writer.append(c);
                        } else if ((long)c.getValueLength() <= this.mobSizeThreshold) {
                            writer.append(c);
                        } else {
                            long len;
                            ++mobCells;
                            mobFileWriter.append(c);
                            Cell reference = MobUtils.createMobRefCell(c, fileName, this.mobStore.getRefCellTags());
                            writer.append(reference);
                            ++cellsCountCompactedToMob;
                            cellsSizeCompactedToMob += (long)c.getValueLength();
                            if (ioOptimizedMode && (len = mobFileWriter.getPos()) > maxMobFileSize) {
                                mobFileWriter = this.switchToNewMobWriter(mobFileWriter, fd, mobCells, major, request, committedMobWriterFileNames);
                                fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
                                mobCells = 0L;
                            }
                        }
                    }
                    int len = c.getSerializedSize();
                    ++progress.currentCompactedKVs;
                    progress.totalCompactedSize += (long)len;
                    bytesWrittenProgressForShippedCall += (long)len;
                    if (LOG.isDebugEnabled()) {
                        bytesWrittenProgressForLog += (long)len;
                    }
                    throughputController.control(compactionName, len);
                    if (closeChecker.isSizeLimit(this.store, len)) {
                        progress.cancel();
                        boolean bl = false;
                        return bl;
                    }
                    if (kvs == null || bytesWrittenProgressForShippedCall <= shippedCallSizeLimit) continue;
                    ((ShipperListener)((Object)writer)).beforeShipped();
                    kvs.shipped();
                    bytesWrittenProgressForShippedCall = 0L;
                }
                if (LOG.isDebugEnabled() && now - lastMillis >= 60000L) {
                    String rate = String.format("%.2f", (double)bytesWrittenProgressForLog / 1024.0 / ((double)(now - lastMillis) / 1000.0));
                    LOG.debug("Compaction progress: {} {}, rate={} KB/sec, throughputController is {}", new Object[]{compactionName, progress, rate, throughputController});
                    lastMillis = now;
                    bytesWrittenProgressForLog = 0L;
                }
                cells.clear();
            } while (hasMore);
            this.commitOrAbortMobWriter(mobFileWriter, fd.maxSeqId, mobCells, major);
            finished = true;
        }
        catch (InterruptedException e) {
            progress.cancel();
            throw new InterruptedIOException("Interrupted while control throughput of compacting " + compactionName);
        }
        catch (IOException t) {
            String msg = "Mob compaction failed for region: " + this.store.getRegionInfo().getEncodedName();
            throw new IOException(msg, t);
        }
        finally {
            ((ShipperListener)((Object)writer)).beforeShipped();
            throughputController.finish(compactionName);
            if (!finished && mobFileWriter != null) {
                this.clearThreadLocals();
                LOG.debug("Aborting writer for {} because of a compaction failure, Store {}", (Object)mobFileWriter.getPath(), (Object)this.getStoreInfo());
                this.abortWriter(mobFileWriter);
                this.deleteCommittedMobFiles(committedMobWriterFileNames);
            }
        }
        this.mobStore.updateCellsCountCompactedFromMob(cellsCountCompactedFromMob);
        this.mobStore.updateCellsCountCompactedToMob(cellsCountCompactedToMob);
        this.mobStore.updateCellsSizeCompactedFromMob(cellsSizeCompactedFromMob);
        this.mobStore.updateCellsSizeCompactedToMob(cellsSizeCompactedToMob);
        progress.complete();
        return true;
    }

    protected String getStoreInfo() {
        return String.format("[table=%s family=%s region=%s]", this.store.getTableName().getNameAsString(), this.store.getColumnFamilyName(), this.store.getRegionInfo().getEncodedName());
    }

    private void clearThreadLocals() {
        mobRefSet.get().clear();
        HashMap<String, Long> map = mobLengthMap.get();
        if (map != null) {
            map.clear();
        }
    }

    private StoreFileWriter newMobWriter(Compactor.FileDetails fd, boolean major, Consumer<Path> writerCreationTracker) throws IOException {
        try {
            StoreFileWriter mobFileWriter = this.mobStore.getStoreEngine().requireWritingToTmpDirFirst() ? this.mobStore.createWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, major ? this.majorCompactionCompression : this.minorCompactionCompression, this.store.getRegionInfo().getStartKey(), true) : this.mobStore.createWriter(new Date(fd.latestPutTs), fd.maxKeyCount, major ? this.majorCompactionCompression : this.minorCompactionCompression, this.store.getRegionInfo().getStartKey(), true, writerCreationTracker);
            LOG.debug("New MOB writer created={} store={}", (Object)mobFileWriter.getPath().getName(), (Object)this.getStoreInfo());
            mobRefSet.get().put((Object)this.store.getTableName(), (Object)mobFileWriter.getPath().getName());
            return mobFileWriter;
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to create mob writer, store=%s", this.getStoreInfo()), e);
        }
    }

    private void commitOrAbortMobWriter(StoreFileWriter mobFileWriter, long maxSeqId, long mobCells, boolean major) throws IOException {
        if (mobFileWriter != null) {
            LOG.debug("Commit or abort size={} mobCells={} major={} file={}, store={}", new Object[]{mobFileWriter.getPos(), mobCells, major, mobFileWriter.getPath().getName(), this.getStoreInfo()});
            Path path = MobUtils.getMobFamilyPath(this.conf, this.store.getTableName(), this.store.getColumnFamilyName());
            if (mobCells > 0L) {
                mobFileWriter.appendMetadata(maxSeqId, major, mobCells);
                mobFileWriter.close();
                this.mobStore.commitFile(mobFileWriter.getPath(), path);
            } else {
                LOG.debug("Aborting writer for {} because there are no MOB cells, store={}", (Object)mobFileWriter.getPath(), (Object)this.getStoreInfo());
                mobRefSet.get().remove((Object)this.store.getTableName(), (Object)mobFileWriter.getPath().getName());
                this.abortWriter(mobFileWriter);
            }
        } else {
            LOG.debug("Mob file writer is null, skipping commit/abort, store=", (Object)this.getStoreInfo());
        }
    }

    @Override
    protected List<Path> commitWriter(StoreFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
        ArrayList newFiles = Lists.newArrayList((Object[])new Path[]{writer.getPath()});
        writer.appendMetadata(fd.maxSeqId, request.isAllFiles(), request.getFiles());
        writer.appendMobMetadata(mobRefSet.get());
        writer.close();
        this.clearThreadLocals();
        return newFiles;
    }

    private StoreFileWriter switchToNewMobWriter(StoreFileWriter mobFileWriter, Compactor.FileDetails fd, long mobCells, boolean major, CompactionRequestImpl request, List<String> committedMobWriterFileNames) throws IOException {
        this.commitOrAbortMobWriter(mobFileWriter, fd.maxSeqId, mobCells, major);
        committedMobWriterFileNames.add(mobFileWriter.getPath().getName());
        return this.newMobWriter(fd, major, request.getWriterCreationTracker());
    }

    private void deleteCommittedMobFiles(List<String> fileNames) {
        if (fileNames.isEmpty()) {
            return;
        }
        Path mobColumnFamilyPath = MobUtils.getMobFamilyPath(this.conf, this.store.getTableName(), this.store.getColumnFamilyName());
        for (String fileName : fileNames) {
            if (fileName == null) continue;
            Path path = new Path(mobColumnFamilyPath, fileName);
            try {
                if (!this.store.getFileSystem().exists(path)) continue;
                this.store.getFileSystem().delete(path, false);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete the mob file {} for an failed mob compaction.", (Object)path, (Object)e);
            }
        }
    }
}

