/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalDistributedRegion;
import org.apache.geode.internal.cache.LatestLastAccessTimeReplyProcessor;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class LatestLastAccessTimeMessage<K>
extends PooledDistributionMessage
implements MessageWithReply {
    private int processorId;
    private String regionName;
    private K key;

    public LatestLastAccessTimeMessage() {
    }

    public LatestLastAccessTimeMessage(LatestLastAccessTimeReplyProcessor replyProcessor, Set<InternalDistributedMember> recipients, InternalDistributedRegion region, K key) {
        this.setRecipients(recipients);
        this.processorId = replyProcessor.getProcessorId();
        this.key = key;
        this.regionName = region.getFullPath();
    }

    public int getDSFID() {
        return -20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        long lastAccessed = 0L;
        try {
            InternalCache cache = dm.getCache();
            if (cache == null) {
                return;
            }
            InternalDistributedRegion region = (InternalDistributedRegion)cache.getRegion(this.regionName);
            if (region == null) {
                return;
            }
            RegionEntry entry = region.getRegionEntry(this.key);
            if (entry == null) {
                return;
            }
            RegionEntry regionEntry = entry;
            synchronized (regionEntry) {
                if (!entry.isInvalidOrRemoved()) {
                    try {
                        lastAccessed = entry.getLastAccessed();
                    }
                    catch (InternalStatisticsDisabledException internalStatisticsDisabledException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.sendReply(dm, lastAccessed);
        }
    }

    @VisibleForTesting
    void sendReply(ClusterDistributionManager dm, long lastAccessTime) {
        ReplyMessage.send(this.getSender(), this.processorId, lastAccessTime, (ReplySender)dm);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = DataSerializer.readPrimitiveInt(in);
        this.regionName = DataSerializer.readString(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writePrimitiveInt(this.processorId, out);
        DataSerializer.writeString(this.regionName, out);
        DataSerializer.writeObject(this.key, out);
    }
}

