/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.ProviderContext;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DataStreamScanProvider;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.examples.java.connectors.SocketSource;
import org.apache.flink.table.types.DataType;

public final class SocketDynamicTableSource
implements ScanTableSource {
    private final String hostname;
    private final int port;
    private final byte byteDelimiter;
    private final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    private final DataType producedDataType;

    public SocketDynamicTableSource(String hostname, int port, byte byteDelimiter, DecodingFormat<DeserializationSchema<RowData>> decodingFormat, DataType producedDataType) {
        this.hostname = hostname;
        this.port = port;
        this.byteDelimiter = byteDelimiter;
        this.decodingFormat = decodingFormat;
        this.producedDataType = producedDataType;
    }

    public ChangelogMode getChangelogMode() {
        return this.decodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(final ScanTableSource.ScanContext runtimeProviderContext) {
        return new DataStreamScanProvider(){

            public DataStream<RowData> produceDataStream(ProviderContext providerContext, StreamExecutionEnvironment execEnv) {
                DeserializationSchema deserializer = (DeserializationSchema)SocketDynamicTableSource.this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, SocketDynamicTableSource.this.producedDataType);
                SocketSource socketSource = new SocketSource(SocketDynamicTableSource.this.hostname, SocketDynamicTableSource.this.port, SocketDynamicTableSource.this.byteDelimiter, (DeserializationSchema<RowData>)deserializer);
                return execEnv.fromSource((Source)socketSource, WatermarkStrategy.noWatermarks(), "SocketSource").setParallelism(1);
            }

            public boolean isBounded() {
                return false;
            }
        };
    }

    public DynamicTableSource copy() {
        return new SocketDynamicTableSource(this.hostname, this.port, this.byteDelimiter, this.decodingFormat, this.producedDataType);
    }

    public String asSummaryString() {
        return "Socket Table Source";
    }
}

