/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.RuntimeConverter;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;

public final class ChangelogCsvDeserializer
implements DeserializationSchema<RowData> {
    private final List<LogicalType> parsingTypes;
    private final DynamicTableSource.DataStructureConverter converter;
    private final TypeInformation<RowData> producedTypeInfo;
    private final String columnDelimiter;

    public ChangelogCsvDeserializer(List<LogicalType> parsingTypes, DynamicTableSource.DataStructureConverter converter, TypeInformation<RowData> producedTypeInfo, String columnDelimiter) {
        this.parsingTypes = parsingTypes;
        this.converter = converter;
        this.producedTypeInfo = producedTypeInfo;
        this.columnDelimiter = columnDelimiter;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public void open(DeserializationSchema.InitializationContext context) {
        this.converter.open(RuntimeConverter.Context.create((ClassLoader)ChangelogCsvDeserializer.class.getClassLoader()));
    }

    public RowData deserialize(byte[] message) {
        String[] columns = new String(message).split(Pattern.quote(this.columnDelimiter));
        RowKind kind = RowKind.valueOf((String)columns[0]);
        Row row = new Row(kind, this.parsingTypes.size());
        for (int i = 0; i < this.parsingTypes.size(); ++i) {
            row.setField(i, ChangelogCsvDeserializer.parse(this.parsingTypes.get(i).getTypeRoot(), columns[i + 1]));
        }
        return (RowData)this.converter.toInternal((Object)row);
    }

    private static Object parse(LogicalTypeRoot root, String value) {
        switch (root) {
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case VARCHAR: {
                return value;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }
}

