/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class SearchResultEntryDecorator
extends MessageDecorator<SearchResultEntry>
implements SearchResultEntry {
    private byte[] objectNameBytes;
    private int searchResultEntryLength;
    private int attributesLength;
    private List<Integer> attributeLength;
    private List<byte[]> attributeIds;
    private List<Integer> valuesLength;
    private Attribute currentAttribute;

    public SearchResultEntryDecorator(LdapApiService codec, SearchResultEntry decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public Attribute getCurrentAttribute() {
        return this.currentAttribute;
    }

    public void addAttribute(String type) throws LdapException {
        this.currentAttribute = new DefaultAttribute(type);
        ((SearchResultEntry)this.getDecorated()).getEntry().put(new Attribute[]{this.currentAttribute});
    }

    public void addAttribute(byte[] type) throws LdapException {
        this.currentAttribute = new DefaultAttribute(type);
        ((SearchResultEntry)this.getDecorated()).getEntry().put(new Attribute[]{this.currentAttribute});
    }

    public void addAttributeValue(Object value) throws LdapException {
        if (value instanceof String) {
            this.currentAttribute.add(new String[]{(String)value});
        } else {
            this.currentAttribute.add((byte[][])new byte[][]{(byte[])value});
        }
    }

    public Dn getObjectName() {
        return ((SearchResultEntry)this.getDecorated()).getObjectName();
    }

    public void setObjectName(Dn objectName) {
        ((SearchResultEntry)this.getDecorated()).setObjectName(objectName);
    }

    public Entry getEntry() {
        return ((SearchResultEntry)this.getDecorated()).getEntry();
    }

    public void setEntry(Entry entry) {
        ((SearchResultEntry)this.getDecorated()).setEntry(entry);
    }

    @Override
    public int computeLength() {
        Dn dn = this.getObjectName();
        this.objectNameBytes = Strings.getBytesUtf8Ascii((String)dn.getName());
        this.searchResultEntryLength = 1 + TLV.getNbBytes((int)this.objectNameBytes.length) + this.objectNameBytes.length;
        this.attributesLength = 0;
        Entry entry = this.getEntry();
        if (entry != null && entry.size() != 0) {
            this.attributeLength = new LinkedList<Integer>();
            this.attributeIds = new LinkedList<byte[]>();
            this.valuesLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            for (Attribute attribute : entry) {
                int localValuesLength = 0;
                byte[] attributeIdBytes = Strings.getBytesUtf8Ascii((String)attribute.getUpId());
                this.attributeIds.add(attributeIdBytes);
                int idLength = attributeIdBytes.length;
                int localAttributeLength = 1 + TLV.getNbBytes((int)idLength) + idLength;
                if (attribute.size() != 0) {
                    if (attribute.size() > 0) {
                        localValuesLength = 0;
                        for (Value value : attribute) {
                            byte[] binaryValue = value.getBytes();
                            localValuesLength += 1 + TLV.getNbBytes((int)binaryValue.length) + binaryValue.length;
                        }
                        localAttributeLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength;
                    } else {
                        localAttributeLength += 2;
                    }
                } else {
                    localAttributeLength += 2;
                }
                this.attributesLength += 1 + TLV.getNbBytes((int)localAttributeLength) + localAttributeLength;
                this.attributeLength.add(localAttributeLength);
                this.valuesLength.add(localValuesLength);
            }
        }
        this.searchResultEntryLength += 1 + TLV.getNbBytes((int)this.attributesLength) + this.attributesLength;
        return 1 + TLV.getNbBytes((int)this.searchResultEntryLength) + this.searchResultEntryLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)100);
            buffer.put(TLV.getBytes((int)this.searchResultEntryLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])this.objectNameBytes);
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.attributesLength));
            Entry entry = this.getEntry();
            if (entry != null && entry.size() != 0) {
                int attributeNumber = 0;
                for (Attribute attribute : entry) {
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localAttributeLength = this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localAttributeLength));
                    BerValue.encode((ByteBuffer)buffer, (byte[])this.attributeIds.get(attributeNumber));
                    buffer.put(UniversalTag.SET.getValue());
                    int localValuesLength = this.valuesLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    if (attribute.size() > 0) {
                        for (Value value : attribute) {
                            BerValue.encode((ByteBuffer)buffer, (byte[])value.getBytes());
                        }
                    }
                    ++attributeNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

