/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv;

import java.util.Arrays;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponse;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResultCode;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class VirtualListViewResponseImpl
extends AbstractControl
implements VirtualListViewResponse {
    private int targetPosition;
    private int contentCount;
    private VirtualListViewResultCode virtualListViewResult;
    private byte[] contextId;

    public VirtualListViewResponseImpl() {
        super("2.16.840.1.113730.3.4.10");
    }

    @Override
    public int getTargetPosition() {
        return this.targetPosition;
    }

    @Override
    public void setTargetPosition(int targetPosition) {
        this.targetPosition = targetPosition;
    }

    @Override
    public int getContentCount() {
        return this.contentCount;
    }

    @Override
    public void setContentCount(int contentCount) {
        this.contentCount = contentCount;
    }

    @Override
    public VirtualListViewResultCode getVirtualListViewResult() {
        return this.virtualListViewResult;
    }

    @Override
    public void setVirtualListViewResult(VirtualListViewResultCode virtualListViewResultCode) {
        this.virtualListViewResult = virtualListViewResultCode;
    }

    @Override
    public byte[] getContextId() {
        return this.contextId;
    }

    @Override
    public void setContextId(byte[] contextId) {
        this.contextId = contextId;
    }

    public int hashCode() {
        int h = super.hashCode();
        h = h * 37 + this.targetPosition;
        h = h * 37 + this.contentCount;
        h = h * 37 + (this.virtualListViewResult == null ? 0 : this.virtualListViewResult.hashCode());
        if (this.contextId != null) {
            for (byte b : this.contextId) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        VirtualListViewResponseImpl otherControl = (VirtualListViewResponseImpl)o;
        return this.targetPosition == otherControl.getTargetPosition() && this.contentCount == otherControl.getContentCount() && this.virtualListViewResult == otherControl.getVirtualListViewResult() && Arrays.equals(this.contextId, otherControl.getContextId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Virtual List View Response Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        targetPosition   : '").append(this.targetPosition).append("'\n");
        sb.append("        contentCount   : '").append(this.contentCount).append("'\n");
        sb.append("        virtualListViewResult   : '").append((Object)this.virtualListViewResult).append("'\n");
        if (this.contextId != null) {
            sb.append("        contextID   : '").append(Strings.dumpBytes((byte[])this.contextId)).append("'\n");
        }
        return sb.toString();
    }
}

