/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.filter.AbstractExprNode;
import org.apache.directory.api.ldap.model.filter.Assertion;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;

public abstract class AssertionNode
extends AbstractExprNode {
    private final Assertion assertion;
    private final String desc;

    public AssertionNode(Assertion assertion) {
        this(assertion, "ASSERTION");
        this.isSchemaAware = true;
    }

    public AssertionNode(Assertion assertion, String desc) {
        super(AssertionType.ASSERTION);
        this.desc = desc;
        this.assertion = assertion;
        this.set("count", Long.MAX_VALUE);
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_04145, new Object[0]));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AssertionNode)) {
            return false;
        }
        AssertionNode that = (AssertionNode)obj;
        if (this.assertion == null ? that.assertion != null : !this.assertion.equals(that.assertion)) {
            return false;
        }
        if (this.desc == null ? that.desc != null : !this.desc.equals(that.desc)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.assertion != null ? this.assertion.hashCode() : 0);
        h = h * 17 + (this.desc != null ? this.desc.hashCode() : 0);
        return h;
    }

    @Override
    public Object accept(FilterVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(@");
        buf.append(this.desc);
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

