/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateTypeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValueImpl;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueContainer;

public class SyncStateValueDecorator
extends ControlDecorator<SyncStateValue>
implements SyncStateValue {
    private int syncStateSeqLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public SyncStateValueDecorator(LdapApiService codec) {
        super(codec, new SyncStateValueImpl());
    }

    public SyncStateValueDecorator(LdapApiService codec, SyncStateValue value) {
        super(codec, value);
    }

    @Override
    public byte[] getCookie() {
        return ((SyncStateValue)this.getDecorated()).getCookie();
    }

    @Override
    public void setCookie(byte[] cookie) {
        ((SyncStateValue)this.getDecorated()).setCookie(cookie);
    }

    @Override
    public SyncStateTypeEnum getSyncStateType() {
        return ((SyncStateValue)this.getDecorated()).getSyncStateType();
    }

    @Override
    public void setSyncStateType(SyncStateTypeEnum syncStateType) {
        ((SyncStateValue)this.getDecorated()).setSyncStateType(syncStateType);
    }

    @Override
    public byte[] getEntryUUID() {
        return ((SyncStateValue)this.getDecorated()).getEntryUUID();
    }

    @Override
    public void setEntryUUID(byte[] entryUUID) {
        ((SyncStateValue)this.getDecorated()).setEntryUUID(entryUUID);
    }

    @Override
    public int computeLength() {
        this.syncStateSeqLength = 3;
        this.syncStateSeqLength += 1 + TLV.getNbBytes(this.getEntryUUID().length) + this.getEntryUUID().length;
        if (this.getCookie() != null) {
            this.syncStateSeqLength += 1 + TLV.getNbBytes(this.getCookie().length) + this.getCookie().length;
        }
        this.valueLength = 1 + TLV.getNbBytes(this.syncStateSeqLength) + this.syncStateSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.syncStateSeqLength));
        buffer.put(UniversalTag.ENUMERATED.getValue());
        buffer.put((byte)1);
        buffer.put(BerValue.getBytes(this.getSyncStateType().getValue()));
        BerValue.encode(buffer, this.getEntryUUID());
        if (this.getCookie() != null) {
            BerValue.encode(buffer, this.getCookie());
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(this.syncStateSeqLength));
                buffer.put(UniversalTag.ENUMERATED.getValue());
                buffer.put((byte)1);
                buffer.put(BerValue.getBytes(this.getSyncStateType().getValue()));
                BerValue.encode(buffer, this.getEntryUUID());
                if (this.getCookie() != null) {
                    BerValue.encode(buffer, this.getCookie());
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncStateValueContainer container = new SyncStateValueContainer(this);
        DECODER.decode(bb, container);
        return this;
    }
}

