/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.DescriptionUtils;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyntaxChecker
extends LoadableSchemaObject {
    public static final long serialVersionUID = 1L;
    protected static final Logger LOG = LoggerFactory.getLogger(SyntaxChecker.class);

    protected SyntaxChecker(String oid) {
        super(SchemaObjectType.SYNTAX_CHECKER, oid);
    }

    protected SyntaxChecker() {
        super(SchemaObjectType.SYNTAX_CHECKER);
    }

    public boolean isValidSyntax(Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
        }
        return true;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return o instanceof SyntaxChecker;
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    public static abstract class SCBuilder<SC> {
        protected String oid;

        protected SCBuilder(String oid) {
            this.oid = oid;
        }

        public SCBuilder<SC> setOid(String oid) {
            this.oid = oid;
            return this;
        }

        public abstract SC build();
    }
}

