/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.util;

import java.nio.charset.StandardCharsets;

public final class Asn1StringUtils {
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final byte[] EMPTY_BYTES = new byte[0];

    private Asn1StringUtils() {
    }

    public static String dumpByte(byte octet) {
        return new String(new byte[]{48, 120, HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]}, StandardCharsets.UTF_8);
    }

    public static String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : buffer) {
            sb.append("0x").append((char)HEX_CHAR[(b & 0xF0) >> 4]).append((char)HEX_CHAR[b & 0xF]).append(" ");
        }
        return sb.toString();
    }

    public static byte[] getBytesUtf8(String string) {
        if (string == null) {
            return EMPTY_BYTES;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] asciiStringToByte(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY_BYTES;
        }
        byte[] result = new byte[string.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)string.charAt(i);
        }
        return result;
    }
}

