/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.util.Strings;

public class BooleanNormalizer
extends Normalizer {
    public BooleanNormalizer() {
        super("2.5.13.13");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapInvalidDnException {
        if (value == null) {
            return null;
        }
        String strValue = value.getString();
        return new StringValue(Strings.upperCase((String)strValue.trim()));
    }

    @Override
    public String normalize(String value) throws LdapInvalidDnException {
        if (value == null) {
            return null;
        }
        return Strings.upperCase((String)value.trim());
    }
}

