/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSetOperationBuilder;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchMiscTest {
    private static MemorySegment getCompactSketchMemorySegment(int k, int from, int to) {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        for (int i = from; i < to; ++i) {
            sk1.update((long)i);
        }
        CompactThetaSketch csk = sk1.compact(true, null);
        byte[] sk1bytes = csk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(sk1bytes).asReadOnly();
        return seg;
    }

    private static MemorySegment getMemorySegmentFromCompactSketch(CompactThetaSketch csk) {
        byte[] sk1bytes = csk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(sk1bytes).asReadOnly();
        return seg;
    }

    private static CompactThetaSketch getCompactSketch(int k, int from, int to) {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        for (int i = from; i < to; ++i) {
            sk1.update((long)i);
        }
        return sk1.compact(true, null);
    }

    @Test
    public void checkSketchMethods() {
        int k = 1024;
        MemorySegment seg = SketchMiscTest.getCompactSketchMemorySegment(1024, 0, 1024);
        CompactThetaSketch csk2 = (CompactThetaSketch)ThetaSketch.heapify((MemorySegment)seg);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)1024);
        csk2 = (CompactThetaSketch)ThetaSketch.heapify((MemorySegment)seg, (long)9001L);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)1024);
        csk2 = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)seg);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)1024);
        csk2 = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)seg, (long)9001L);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)1024);
    }

    @Test
    public void checkSetOpMethods() {
        int k = 1024;
        MemorySegment seg1 = SketchMiscTest.getCompactSketchMemorySegment(1024, 0, 1024);
        MemorySegment seg2 = SketchMiscTest.getCompactSketchMemorySegment(1024, 512, 1536);
        ThetaSetOperationBuilder bldr = ThetaSetOperation.builder();
        ThetaUnion union = bldr.setNominalEntries(2048).buildUnion();
        union.union(seg1);
        CompactThetaSketch cSk = union.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)1024);
        union.union(seg2);
        cSk = union.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)1536);
        byte[] ubytes = union.toByteArray();
        MemorySegment uSeg = MemorySegment.ofArray(ubytes);
        ThetaUnion union2 = (ThetaUnion)ThetaSetOperation.heapify((MemorySegment)uSeg);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)1536);
        union2 = (ThetaUnion)ThetaSetOperation.heapify((MemorySegment)uSeg, (long)9001L);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)1536);
        union2 = (ThetaUnion)ThetaSetOperation.wrap((MemorySegment)uSeg);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)1536);
        union2 = (ThetaUnion)ThetaSetOperation.wrap((MemorySegment)uSeg, (long)9001L);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)1536);
        int serVer = ThetaSketch.getSerializationVersion((MemorySegment)uSeg);
        Assert.assertEquals((int)serVer, (int)3);
    }

    @Test
    public void checkUtilMethods() {
        int lgK = 10;
        int k = 1024;
        int maxUnionBytes = ThetaSetOperation.getMaxUnionBytes((int)1024);
        Assert.assertEquals((int)16416, (int)maxUnionBytes);
        int maxInterBytes = ThetaSetOperation.getMaxIntersectionBytes((int)1024);
        Assert.assertEquals((int)16408, (int)maxInterBytes);
        int maxCompSkBytes = ThetaSketch.getMaxCompactSketchBytes((int)1025);
        Assert.assertEquals((int)8224, (int)maxCompSkBytes);
        int compSkMaxBytes = ThetaSketch.getCompactSketchMaxBytes((int)10);
        int bytes = (int)(1920.0 + (double)Family.QUICKSELECT.getMaxPreLongs()) * 8;
        Assert.assertEquals((int)compSkMaxBytes, (int)bytes);
        int maxSkBytes = ThetaSketch.getMaxUpdateSketchBytes((int)1024);
        Assert.assertEquals((int)16408, (int)maxSkBytes);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSketchFamily() {
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        byte[] byteArr = union.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(byteArr);
        ThetaSketch.getEstimate((MemorySegment)srcSeg);
    }

    @Test
    public void printlnTest() {
        SketchMiscTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

