/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CertConstraintsParser {
    private Collection<Pattern> subjectDNPatterns = new ArrayList<Pattern>();

    public void setSubjectConstraints(List<String> constraints) {
        if (constraints != null) {
            this.subjectDNPatterns = new ArrayList<Pattern>();
            for (String constraint : constraints) {
                this.subjectDNPatterns.add(Pattern.compile(constraint.trim()));
            }
        }
    }

    public boolean matches(X509Certificate cert) {
        if (!this.subjectDNPatterns.isEmpty()) {
            if (cert == null) {
                return false;
            }
            String subjectName = cert.getSubjectX500Principal().getName();
            boolean subjectMatch = false;
            for (Pattern subjectDNPattern : this.subjectDNPatterns) {
                Matcher matcher = subjectDNPattern.matcher(subjectName);
                if (!matcher.matches()) continue;
                subjectMatch = true;
                break;
            }
            if (!subjectMatch) {
                return false;
            }
        }
        return true;
    }
}

