/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.manager;

import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.eventing.ExpirationType;
import org.apache.cxf.ws.eventing.GetStatus;
import org.apache.cxf.ws.eventing.GetStatusResponse;
import org.apache.cxf.ws.eventing.Renew;
import org.apache.cxf.ws.eventing.RenewResponse;
import org.apache.cxf.ws.eventing.Unsubscribe;
import org.apache.cxf.ws.eventing.UnsubscribeResponse;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionTicket;
import org.apache.cxf.ws.eventing.backend.manager.SubscriptionManagerInterfaceForManagers;
import org.apache.cxf.ws.eventing.manager.SubscriptionManagerEndpoint;
import org.apache.cxf.ws.eventing.shared.faults.UnknownSubscription;
import org.apache.cxf.ws.eventing.shared.utils.DurationAndDateUtil;

public abstract class AbstractSubscriptionManager
implements SubscriptionManagerEndpoint {
    protected static final Logger LOG = LogUtils.getLogger(AbstractSubscriptionManager.class);
    @Resource
    protected WebServiceContext context;

    @Override
    public RenewResponse renewOp(Renew body) {
        RenewResponse response = new RenewResponse();
        String uuid = this.retrieveSubscriptionUUID();
        LOG.info("received Renew message for UUID=" + uuid);
        ExpirationType expiration = this.getSubscriptionManagerBackend().renew(UUID.fromString(uuid), body.getExpires());
        response.setGrantedExpires(expiration);
        LOG.info("Extended subscription for UUID=" + uuid + " to " + expiration.getValue());
        return response;
    }

    @Override
    public GetStatusResponse getStatusOp(GetStatus body) {
        String uuid = this.retrieveSubscriptionUUID();
        LOG.info("received GetStatus message for UUID=" + uuid);
        SubscriptionTicket ticket = this.obtainTicketFromDatabaseOrThrowFault(uuid);
        GetStatusResponse response = new GetStatusResponse();
        response.setGrantedExpires(DurationAndDateUtil.toExpirationTypeContainingGregorianCalendar(ticket.getExpires()));
        return response;
    }

    @Override
    public UnsubscribeResponse unsubscribeOp(Unsubscribe body) {
        String uuid = this.retrieveSubscriptionUUID();
        LOG.info("received Unsubscribe message for UUID=" + uuid);
        this.getSubscriptionManagerBackend().unsubscribeTicket(UUID.fromString(uuid));
        LOG.info("successfully removed subscription with UUID " + uuid);
        return new UnsubscribeResponse();
    }

    protected abstract SubscriptionManagerInterfaceForManagers getSubscriptionManagerBackend();

    protected String retrieveSubscriptionUUID() {
        Object uuid = ((WrappedMessageContext)this.context.getMessageContext()).getWrappedMessage().getContextualProperty("uuid");
        if (uuid == null) {
            throw new UnknownSubscription();
        }
        if (uuid.getClass() != String.class) {
            throw new Error("Subscription ID should be a String but is " + uuid.getClass().getName());
        }
        return (String)uuid;
    }

    protected SubscriptionTicket obtainTicketFromDatabaseOrThrowFault(String uuid) {
        SubscriptionTicket ticket = this.getSubscriptionManagerBackend().findTicket(UUID.fromString(uuid));
        if (ticket == null) {
            LOG.severe("Unknown ticket UUID: " + uuid);
            throw new UnknownSubscription();
        }
        return ticket;
    }
}

