/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser;

import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.SchemaSetImpl;
import com.sun.xml.xsom.impl.parser.NGCCRuntimeEx;
import com.sun.xml.xsom.impl.parser.Patch;
import com.sun.xml.xsom.impl.parser.PatcherManager;
import com.sun.xml.xsom.impl.parser.SchemaDocumentImpl;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XMLParser;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserContext {
    public final SchemaSetImpl schemaSet = new SchemaSetImpl();
    private final XSOMParser owner;
    final XMLParser parser;
    private final Vector<Patch> patchers = new Vector();
    private final Vector<Patch> errorCheckers = new Vector();
    public final Map<SchemaDocumentImpl, SchemaDocumentImpl> parsedDocuments = new HashMap<SchemaDocumentImpl, SchemaDocumentImpl>();
    private boolean hadError = false;
    final PatcherManager patcherManager = new PatcherManager(){

        @Override
        public void addPatcher(Patch patch) {
            ParserContext.this.patchers.add(patch);
        }

        @Override
        public void addErrorChecker(Patch patch) {
            ParserContext.this.errorCheckers.add(patch);
        }

        @Override
        public void reportError(String msg, Locator src) throws SAXException {
            ParserContext.this.setErrorFlag();
            SAXParseException e = new SAXParseException(msg, src);
            if (ParserContext.this.errorHandler == null) {
                throw e;
            }
            ParserContext.this.errorHandler.error(e);
        }
    };
    final ErrorHandler errorHandler = new ErrorHandler(){

        private ErrorHandler getErrorHandler() {
            if (ParserContext.this.owner.getErrorHandler() == null) {
                return ParserContext.this.noopHandler;
            }
            return ParserContext.this.owner.getErrorHandler();
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.getErrorHandler().warning(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            ParserContext.this.setErrorFlag();
            this.getErrorHandler().error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            ParserContext.this.setErrorFlag();
            this.getErrorHandler().fatalError(e);
        }
    };
    final ErrorHandler noopHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException e) {
        }

        @Override
        public void error(SAXParseException e) {
        }

        @Override
        public void fatalError(SAXParseException e) {
            ParserContext.this.setErrorFlag();
        }
    };

    public ParserContext(XSOMParser owner, XMLParser parser) {
        this.owner = owner;
        this.parser = parser;
        try (InputStream is = ParserContext.class.getResourceAsStream("datatypes.xsd");){
            InputSource source = new InputSource(is);
            source.setSystemId("datatypes.xsd");
            this.parse(source);
            SchemaImpl xs = (SchemaImpl)this.schemaSet.getSchema("http://www.w3.org/2001/XMLSchema");
            xs.addSimpleType(this.schemaSet.anySimpleType, true);
            xs.addComplexType(this.schemaSet.anyType, true);
        }
        catch (IOException | SAXException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public EntityResolver getEntityResolver() {
        return this.owner.getEntityResolver();
    }

    public AnnotationParserFactory getAnnotationParserFactory() {
        return this.owner.getAnnotationParserFactory();
    }

    public void parse(InputSource source) throws SAXException {
        this.newNGCCRuntime().parseEntity(source, false, null, null);
    }

    public XSSchemaSet getResult() throws SAXException {
        for (Patch patcher : this.patchers) {
            patcher.run();
        }
        this.patchers.clear();
        Iterator<XSElementDecl> itr = this.schemaSet.iterateElementDecls();
        while (itr.hasNext()) {
            ((ElementDecl)itr.next()).updateSubstitutabilityMap();
        }
        for (Patch patcher : this.errorCheckers) {
            patcher.run();
        }
        this.errorCheckers.clear();
        if (this.hadError) {
            return null;
        }
        return this.schemaSet;
    }

    public NGCCRuntimeEx newNGCCRuntime() {
        return new NGCCRuntimeEx(this);
    }

    void setErrorFlag() {
        this.hadError = true;
    }
}

